/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.algo.tf;

import com.segway.robot.algo.tf.Quaternion;
import com.segway.robot.algo.tf.Translation;

public class Matrix4 {
    public static final int M00 = 0;
    public static final int M01 = 4;
    public static final int M02 = 8;
    public static final int M03 = 12;
    public static final int M10 = 1;
    public static final int M11 = 5;
    public static final int M12 = 9;
    public static final int M13 = 13;
    public static final int M20 = 2;
    public static final int M21 = 6;
    public static final int M22 = 10;
    public static final int M23 = 14;
    public static final int M30 = 3;
    public static final int M31 = 7;
    public static final int M32 = 11;
    public static final int M33 = 15;
    public final float[] val = new float[16];

    public Matrix4() {
        this.val[0] = 1.0f;
        this.val[5] = 1.0f;
        this.val[10] = 1.0f;
        this.val[15] = 1.0f;
    }

    public Matrix4 setTranslation(float x, float y, float z) {
        this.val[12] = x;
        this.val[13] = y;
        this.val[14] = z;
        return this;
    }

    public Matrix4 setQuaternion(float x, float y, float z, float w) {
        return this.set(0.0f, 0.0f, 0.0f, x, y, z, w);
    }

    public Matrix4 set(float translationX, float translationY, float translationZ, float quaternionX, float quaternionY, float quaternionZ, float quaternionW) {
        float xs = quaternionX * 2.0f;
        float ys = quaternionY * 2.0f;
        float zs = quaternionZ * 2.0f;
        float wx = quaternionW * xs;
        float wy = quaternionW * ys;
        float wz = quaternionW * zs;
        float xx = quaternionX * xs;
        float xy = quaternionX * ys;
        float xz = quaternionX * zs;
        float yy = quaternionY * ys;
        float yz = quaternionY * zs;
        float zz = quaternionZ * zs;
        this.val[0] = 1.0f - (yy + zz);
        this.val[4] = xy - wz;
        this.val[8] = xz + wy;
        this.val[12] = translationX;
        this.val[1] = xy + wz;
        this.val[5] = 1.0f - (xx + zz);
        this.val[9] = yz - wx;
        this.val[13] = translationY;
        this.val[2] = xz - wy;
        this.val[6] = yz + wx;
        this.val[10] = 1.0f - (xx + yy);
        this.val[14] = translationZ;
        this.val[3] = 0.0f;
        this.val[7] = 0.0f;
        this.val[11] = 0.0f;
        this.val[15] = 1.0f;
        return this;
    }

    public float vectorLen(float x, float y, float z) {
        return (float)Math.sqrt(x * x + y * y + z * z);
    }

    public Quaternion getNormalizedQuaternion(float xx, float xy, float xz, float yx, float yy, float yz, float zx, float zy, float zz) {
        float z;
        float y;
        float x;
        float w;
        float s;
        float lx = 1.0f / this.vectorLen(xx, xy, xz);
        float ly = 1.0f / this.vectorLen(yx, yy, yz);
        float lz = 1.0f / this.vectorLen(zx, zy, zz);
        xx *= lx;
        xy *= lx;
        xz *= lx;
        yx *= ly;
        yy *= ly;
        yz *= ly;
        zx *= lz;
        zy *= lz;
        float t = xx + yy + (zz *= lz);
        if (t >= 0.0f) {
            s = (float)Math.sqrt(t + 1.0f);
            w = 0.5f * s;
            s = 0.5f / s;
            x = (zy - yz) * s;
            y = (xz - zx) * s;
            z = (yx - xy) * s;
        } else if (xx > yy && xx > zz) {
            s = (float)Math.sqrt(1.0 + (double)xx - (double)yy - (double)zz);
            x = s * 0.5f;
            s = 0.5f / s;
            y = (yx + xy) * s;
            z = (xz + zx) * s;
            w = (zy - yz) * s;
        } else if (yy > zz) {
            s = (float)Math.sqrt(1.0 + (double)yy - (double)xx - (double)zz);
            y = s * 0.5f;
            s = 0.5f / s;
            x = (yx + xy) * s;
            z = (zy + yz) * s;
            w = (xz - zx) * s;
        } else {
            s = (float)Math.sqrt(1.0 + (double)zz - (double)xx - (double)yy);
            z = s * 0.5f;
            s = 0.5f / s;
            x = (xz + zx) * s;
            y = (zy + yz) * s;
            w = (yx - xy) * s;
        }
        Quaternion q = new Quaternion(x, y, z, w);
        return q;
    }

    public Quaternion getQuaternion() {
        Quaternion q = this.getNormalizedQuaternion(this.val[0], this.val[4], this.val[8], this.val[1], this.val[5], this.val[9], this.val[2], this.val[6], this.val[10]);
        return q;
    }

    public Translation getTranslation() {
        Translation t = new Translation(this.val[12], this.val[13], this.val[14]);
        return t;
    }
}

