package com.segway.robot.algo.generaldts;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by CP on 2017/12/4.
 */

public class GeneralTrackingProfile implements Parcelable {

    /**
     * minimum apple area that can be detected respect to image resolution, eg, mMinimumAppleSize = appleArea / (imgWidth * imgHeight)
     */
    float mMinimumAppleSize;

    public GeneralTrackingProfile(float mMinimumAppleSize) {
        this.mMinimumAppleSize = mMinimumAppleSize;
    }

    protected GeneralTrackingProfile(Parcel in) {
        mMinimumAppleSize = in.readFloat();
    }

    public static final Creator<GeneralTrackingProfile> CREATOR = new Creator<GeneralTrackingProfile>() {
        @Override
        public GeneralTrackingProfile createFromParcel(Parcel in) {
            return new GeneralTrackingProfile(in);
        }

        @Override
        public GeneralTrackingProfile[] newArray(int size) {
            return new GeneralTrackingProfile[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(mMinimumAppleSize);
    }

    @Override
    public String toString() {
        return "GeneralTrackingProfile{" +
                "mMinimumAppleSize=" + mMinimumAppleSize +
                '}';
    }
}