/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.algo;

import android.os.Parcel;
import android.os.Parcelable;
import com.segway.robot.algo.CubeF;
import com.segway.robot.algo.Point3DF;

public class PhysicalObject
extends Point3DF
implements Parcelable {
    protected CubeF mBound;
    public static final Parcelable.Creator<PhysicalObject> CREATOR = new Parcelable.Creator<PhysicalObject>(){

        public PhysicalObject createFromParcel(Parcel in) {
            long timestamp = in.readLong();
            float x = in.readFloat();
            float y = in.readFloat();
            float z = in.readFloat();
            CubeF cubeF = (CubeF)in.readParcelable(CubeF.class.getClassLoader());
            return new PhysicalObject(x, y, z, cubeF, timestamp);
        }

        public PhysicalObject[] newArray(int size) {
            return new PhysicalObject[size];
        }
    };

    public PhysicalObject(float x, float y, float z, CubeF bound, long timeStamp) {
        super(x, y, z, timeStamp);
        this.mBound = bound;
    }

    public CubeF getBound() {
        return this.mBound;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mTimeStamp);
        dest.writeFloat(this.mX);
        dest.writeFloat(this.mY);
        dest.writeFloat(this.mZ);
        dest.writeParcelable((Parcelable)this.mBound, flags);
    }

    @Override
    public String toString() {
        return "PhysicalObject{mBound=" + this.mBound + '}';
    }
}

