package com.segway.robot.algo.tf;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by Yusen.QIN on 2017/12/14.
 */

public class AlgoTfRequest implements Parcelable {
    public String tgtFrameID;
    public String srcFrameID;
    public long timeStamp;
    public long lookupThreshold;

    protected AlgoTfRequest(Parcel in) {
        tgtFrameID = in.readString();
        srcFrameID = in.readString();
        timeStamp = in.readLong();
        lookupThreshold = in.readLong();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(tgtFrameID);
        dest.writeString(srcFrameID);
        dest.writeLong(timeStamp);
        dest.writeLong(lookupThreshold);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<AlgoTfRequest> CREATOR = new Creator<AlgoTfRequest>() {
        @Override
        public AlgoTfRequest createFromParcel(Parcel in) {
            return new AlgoTfRequest(in);
        }

        @Override
        public AlgoTfRequest[] newArray(int size) {
            return new AlgoTfRequest[size];
        }
    };

    public AlgoTfRequest set(String tgtID, String srcID, long ts, long trh){
        this.tgtFrameID = tgtID;
        this.srcFrameID = srcID;
        this.timeStamp = ts;
        this.lookupThreshold = trh;
        return this;
    }

    public AlgoTfRequest(String tgtID, String srcID, long ts, long trh){
        this.set(tgtID, srcID, ts, trh);
    }

}
