package com.segway.robot.algo.dts;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by ark338 on 2016/12/28.
 */

public class PersonTrackingProfile implements Parcelable{
    int mTrackingFps;
    int mPoseFps;
    float mPlannerTolerance;
    boolean mUseUltraSonic;
    // TODO: 2016/12/28 more profile
    public PersonTrackingProfile(int poseFps, float plannerTolerance)
    {
        mPoseFps = poseFps;
        mPlannerTolerance = plannerTolerance;
        mUseUltraSonic = true;
    }

    public PersonTrackingProfile(int poseFps, float plannerTolerance, boolean useUltraSonic)
    {
        mPoseFps = poseFps;
        mPlannerTolerance = plannerTolerance;
        mUseUltraSonic = useUltraSonic;
    }

    protected PersonTrackingProfile(Parcel in) {
        mTrackingFps = in.readInt();
        mPoseFps = in.readInt();
        mPlannerTolerance = in.readFloat();
        mUseUltraSonic = in.readByte() != 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(mTrackingFps);
        dest.writeInt(mPoseFps);
        dest.writeFloat(mPlannerTolerance);
        dest.writeByte((byte) (mUseUltraSonic ? 1 : 0));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<PersonTrackingProfile> CREATOR = new Creator<PersonTrackingProfile>() {
        @Override
        public PersonTrackingProfile createFromParcel(Parcel in) {
            return new PersonTrackingProfile(in);
        }

        @Override
        public PersonTrackingProfile[] newArray(int size) {
            return new PersonTrackingProfile[size];
        }
    };

    /**
     * get the pose recognition frame rate
     * @return
     */
    public int getPoseFps(){
        return mPoseFps;
    }

    /**
     * get the reach tolerance of the planner
     * @return
     */
    public float getPlannerTolerance(){
        return mPlannerTolerance;
    }

    /**
     * set pose fps value
     * @param expectedPoseFps
     */
    public void setPoseFps(int expectedPoseFps){
        mPoseFps = expectedPoseFps;
    }

    /**
     * set expected tolerance of planner
     * @param expectedPlannerTolerance
     */
    public void setPlannerTolerance(float expectedPlannerTolerance){
        mPlannerTolerance = expectedPlannerTolerance;
    }

    @Override
    public String toString() {
        return "PersonTrackingProfile{" +
                "mTrackingFps=" + mTrackingFps +
                ", mPoseFps=" + mPoseFps +
                ", mPlannerTolerance=" + mPlannerTolerance +
                ", mUseUltraSonic=" + mUseUltraSonic +
                '}';
    }

    /**
     * set whether to use ultrasonic
     * @param mUseUltraSonic
     */
    public void setUseUltraSonic(boolean mUseUltraSonic) {
        this.mUseUltraSonic = mUseUltraSonic;
    }

    /**
     * get whether to use ultrasonic
     * @return
     */
    public boolean isUseUltraSonic() {
        return mUseUltraSonic;
    }
}
