/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.algo.generaldts;

import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import com.segway.robot.algo.CubeF;
import com.segway.robot.algo.PhysicalObject;
import com.segway.robot.algo.Pose2D;

public class DTSObject
extends PhysicalObject {
    private int mId;
    private int mType;
    private float mConfidence;
    private Rect mDrawingRect;
    private Pose2D mRobotPose;
    private float mTheta;
    private float mPitch;
    public static final Parcelable.Creator<DTSObject> CREATOR = new Parcelable.Creator<DTSObject>(){

        public DTSObject createFromParcel(Parcel in) {
            float x = in.readFloat();
            float y = in.readFloat();
            float z = in.readFloat();
            CubeF cubeF = (CubeF)in.readParcelable(CubeF.class.getClassLoader());
            int id = in.readInt();
            int type = in.readInt();
            float confidence = in.readFloat();
            Rect rect = (Rect)in.readParcelable(Rect.class.getClassLoader());
            Pose2D pose = (Pose2D)in.readParcelable(Pose2D.class.getClassLoader());
            float theta = in.readFloat();
            float pitch = in.readFloat();
            long timestamp = in.readLong();
            return new DTSObject(x, y, z, cubeF, id, type, confidence, rect, pose, theta, pitch, timestamp);
        }

        public DTSObject[] newArray(int size) {
            return new DTSObject[size];
        }
    };

    public DTSObject(float x, float y, float z, CubeF bound, int id, int type, float confidence, Rect drawingRect, Pose2D robotPose, float theta, float pitch, long timeStamp) {
        super(x, y, z, bound, timeStamp);
        this.mType = type;
        this.mConfidence = confidence;
        this.mDrawingRect = drawingRect;
        this.mRobotPose = robotPose;
        this.mTheta = theta;
        this.mPitch = pitch;
        this.mId = id;
    }

    public DTSObject(DTSObject object) {
        super(object.mX, object.mY, object.mZ, object.mBound, object.mTimeStamp);
        this.mType = object.mType;
        this.mConfidence = object.mConfidence;
        this.mDrawingRect = object.mDrawingRect;
        this.mRobotPose = object.mRobotPose;
        this.mTheta = object.mTheta;
        this.mPitch = object.mPitch;
        this.mId = object.mId;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(this.mX);
        dest.writeFloat(this.mY);
        dest.writeFloat(this.mZ);
        dest.writeParcelable((Parcelable)this.mBound, flags);
        dest.writeInt(this.mId);
        dest.writeInt(this.mType);
        dest.writeFloat(this.mConfidence);
        dest.writeParcelable((Parcelable)this.mDrawingRect, flags);
        dest.writeParcelable((Parcelable)this.mRobotPose, flags);
        dest.writeFloat(this.mTheta);
        dest.writeFloat(this.mPitch);
        dest.writeLong(this.mTimeStamp);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getType() {
        return this.mType;
    }

    public float getConfidence() {
        return this.mConfidence;
    }

    public Rect getDrawingRect() {
        return this.mDrawingRect;
    }

    public Pose2D getRobotPose() {
        return this.mRobotPose;
    }

    public float getTheta() {
        return this.mTheta;
    }

    public float getPitch() {
        return this.mPitch;
    }

    public int getId() {
        return this.mId;
    }

    public void setId(int mId) {
        this.mId = mId;
    }

    @Override
    public String toString() {
        return "DTSObject{mZ=" + this.mZ + ", mBound=" + this.mBound + ", mTimeStamp=" + this.mTimeStamp + ", mX=" + this.mX + ", mY=" + this.mY + ", mId=" + this.mId + ", mType=" + this.mType + ", mConfidence=" + this.mConfidence + ", mDrawingRect=" + this.mDrawingRect + ", mRobotPose=" + this.mRobotPose + ", mTheta=" + this.mTheta + ", mPitch=" + this.mPitch + '}';
    }
}

