/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.algo;

import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import com.segway.robot.algo.Pose2D;
import com.segway.robot.sdk.base.time.StampedData;
import java.nio.ByteBuffer;

public class OccupancyGridMap2D
implements StampedData,
Parcelable {
    public static final int PROBABILITY_UNKNOW = -1;
    public static final int PROBABILITY_PERSON = -2;
    private ByteBuffer mMapBuffer;
    private long mTimestamp;
    private Pose2D mOdometryPose;
    private RectF mBoundary;
    private float mResolution;
    public static final Parcelable.Creator<OccupancyGridMap2D> CREATOR = new Parcelable.Creator<OccupancyGridMap2D>(){

        public OccupancyGridMap2D createFromParcel(Parcel in) {
            return new OccupancyGridMap2D(in);
        }

        public OccupancyGridMap2D[] newArray(int size) {
            return new OccupancyGridMap2D[size];
        }
    };

    public OccupancyGridMap2D(ByteBuffer mapBuffer, long timestamp, Pose2D odometryPose, RectF boundary, float resolution) {
        this.mMapBuffer = mapBuffer;
        this.mTimestamp = timestamp;
        this.mOdometryPose = odometryPose;
        this.mBoundary = boundary;
        this.mResolution = resolution;
    }

    protected OccupancyGridMap2D(Parcel in) {
        this.mTimestamp = in.readLong();
        this.mBoundary = (RectF)in.readParcelable(RectF.class.getClassLoader());
        this.mResolution = in.readFloat();
    }

    Pose2D getOdometryPose() {
        return this.mOdometryPose;
    }

    public ByteBuffer getMapBuffer() {
        return this.mMapBuffer;
    }

    public RectF getBoundary() {
        return this.mBoundary;
    }

    public float getResolution() {
        return this.mResolution;
    }

    public long getTimestamp() {
        return this.mTimestamp;
    }

    public long diff(StampedData source) {
        return source.getTimestamp() - this.getTimestamp();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mTimestamp);
        dest.writeParcelable((Parcelable)this.mBoundary, flags);
        dest.writeFloat(this.mResolution);
    }

    public String toString() {
        return "OccupancyGridMap2D: mTimestamp=" + this.mTimestamp + " mOdometryPose=" + this.mOdometryPose + " mBoundary=" + this.mBoundary + " mResolution=" + this.mResolution;
    }
}

