package com.segway.robot.algo.dts;

import android.os.Parcel;
import android.os.Parcelable;
import com.segway.robot.algo.Point2DF;
import com.segway.robot.algo.Trajectory;

public class FollowTrajectory extends Trajectory implements Parcelable{
    private int mFollowState;
    public int getFollowState() {
        return mFollowState;
    }
    public FollowTrajectory(Point2DF[] trajectory, int followState, long timeStamp) {
        super(trajectory, timeStamp);
        mFollowState = followState;
    }
    
    protected FollowTrajectory(Parcel in) {
        super(in);
        mFollowState = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeInt(mFollowState);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<FollowTrajectory> CREATOR = new Creator<FollowTrajectory>() {
        @Override
        public FollowTrajectory createFromParcel(Parcel in) {
            return new FollowTrajectory(in);
        }

        @Override
        public FollowTrajectory[] newArray(int size) {
            return new FollowTrajectory[size];
        }
    };
}