/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.algo.tf;

import android.os.Parcel;
import android.os.Parcelable;
import com.segway.robot.algo.tf.MathUtils;
import com.segway.robot.algo.tf.Translation;

public class Quaternion
implements Parcelable {
    public float x;
    public float y;
    public float z;
    public float w;
    public static final Parcelable.Creator<Quaternion> CREATOR = new Parcelable.Creator<Quaternion>(){

        public Quaternion createFromParcel(Parcel in) {
            return new Quaternion(in);
        }

        public Quaternion[] newArray(int size) {
            return new Quaternion[size];
        }
    };

    protected Quaternion(Parcel in) {
        this.x = in.readFloat();
        this.y = in.readFloat();
        this.z = in.readFloat();
        this.w = in.readFloat();
    }

    public Quaternion set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public Quaternion(float x, float y, float z, float w) {
        this.set(x, y, z, w);
    }

    public Quaternion set(Quaternion quaternion) {
        return this.set(quaternion.x, quaternion.y, quaternion.z, quaternion.w);
    }

    public int getGimbalPole() {
        float t = this.y * this.x + this.z * this.w;
        if (t > 0.49999f) {
            return 1;
        }
        if (t < -0.49999f) {
            return -1;
        }
        return 0;
    }

    public float getRollRad() {
        int pole = this.getGimbalPole();
        if (pole == 0) {
            return MathUtils.atan2(2.0f * (this.w * this.z + this.y * this.x), 1.0f - 2.0f * (this.x * this.x + this.z * this.z));
        }
        return (float)pole * 2.0f * MathUtils.atan2(this.y, this.w);
    }

    public float getPitchRad() {
        int pole = this.getGimbalPole();
        return pole == 0 ? (float)Math.asin(MathUtils.clamp(2.0f * (this.w * this.x - this.z * this.y), -1.0f, 1.0f)) : (float)pole * (float)Math.PI * 0.5f;
    }

    public float getYawRad() {
        return this.getGimbalPole() == 0 ? MathUtils.atan2(2.0f * (this.y * this.w + this.x * this.z), 1.0f - 2.0f * (this.y * this.y + this.x * this.x)) : 0.0f;
    }

    public float getDegreeFromRadians(float degree) {
        return degree * 57.295776f;
    }

    public Quaternion setEulerRad(float yaw, float pitch, float roll) {
        float halfRoll = roll * 0.5f;
        float sHalfRoll = (float)Math.sin(halfRoll);
        float cHalfRoll = (float)Math.cos(halfRoll);
        float halfPitch = pitch * 0.5f;
        float sHalfPitch = (float)Math.sin(halfPitch);
        float cHalfPitch = (float)Math.cos(halfPitch);
        float halfYaw = yaw * 0.5f;
        float sHalfYaw = (float)Math.sin(halfYaw);
        float cHalfYaw = (float)Math.cos(halfYaw);
        this.x = sHalfRoll * cHalfPitch * cHalfYaw - cHalfRoll * sHalfPitch * sHalfYaw;
        this.y = cHalfRoll * sHalfPitch * cHalfYaw + sHalfRoll * cHalfPitch * sHalfYaw;
        this.z = cHalfRoll * cHalfPitch * sHalfYaw - sHalfRoll * sHalfPitch * cHalfYaw;
        this.w = cHalfRoll * cHalfPitch * cHalfYaw + sHalfRoll * sHalfPitch * sHalfYaw;
        return this;
    }

    public Quaternion setEulerRadZYX(float yaw, float pitch, float roll) {
        this.setEulerRad(roll, pitch, yaw);
        return this;
    }

    public Quaternion inv() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Quaternion mul(Quaternion q) {
        float resX = this.w * q.x + this.x * q.w + this.y * q.z - this.z * q.y;
        float resY = this.w * q.y + this.y * q.w + this.z * q.x - this.x * q.z;
        float resZ = this.w * q.z + this.z * q.w + this.x * q.y - this.y * q.x;
        float resW = this.w * q.w - this.w * q.x - this.y * q.y - this.z * q.z;
        this.x = resX;
        this.y = resY;
        this.z = resZ;
        this.w = resW;
        return this;
    }

    public Quaternion mul(float x, float y, float z, float w) {
        Quaternion q = new Quaternion(x, y, z, w);
        this.mul(q);
        return this;
    }

    public Quaternion mulVector3(Translation t) {
        Quaternion q = new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);
        q.x = this.w * t.x + this.y * t.z - this.z * t.y;
        q.y = this.w * t.y + this.z * t.x - this.x * t.z;
        q.z = this.w * t.z + this.x * t.y - this.y * t.x;
        q.w = -this.x * t.x - this.y * t.y - this.z * t.z;
        return q;
    }

    public Quaternion leftMulVector3(Translation t) {
        Quaternion q = new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);
        q.x = t.x * this.w + t.y * this.z - t.z * this.y;
        q.y = t.y * this.w + t.z * this.x - t.x * this.z;
        q.z = t.z * this.w + t.x * this.y - t.y * this.x;
        q.w = -t.x * this.x - t.y * this.y - t.z * this.z;
        return q;
    }

    public Translation quaternionRotate(Translation t) {
        Quaternion qInv = this.inv();
        Quaternion q = new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);
        q = this.mulVector3(t);
        q = q.mul(qInv);
        Translation v = new Translation(q.x, q.y, q.z);
        return v;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(this.x);
        dest.writeFloat(this.y);
        dest.writeFloat(this.z);
        dest.writeFloat(this.w);
    }

    public String toString() {
        return "Quaternion{x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", w=" + this.w + '}';
    }
}

