package com.segway.robot.algo;

import android.os.Parcel;
import android.os.Parcelable;

import com.segway.robot.sdk.base.time.StampedData;

public class Trajectory implements StampedData, Parcelable{
    private long mTimeStamp;
    private Point2DF[] mTrajectory;
    
    public Trajectory(Point2DF[] trajectory, long timestamp) {
        mTrajectory = trajectory;
        mTimeStamp = timestamp;
    }

    public long getTimestamp() {
        return mTimeStamp;
    }

    public Point2DF[] getTrajectory() {
        return mTrajectory;
    }

    @Override
    public long diff(StampedData source) {
        return 0;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mTimeStamp);
        dest.writeTypedArray(this.mTrajectory, flags);
    }

    protected Trajectory(Parcel in) {
        this.mTimeStamp = in.readLong();
        this.mTrajectory = in.createTypedArray(Point2DF.CREATOR);
    }

    public static final Creator<Trajectory> CREATOR = new Creator<Trajectory>() {
        @Override
        public Trajectory createFromParcel(Parcel source) {
            return new Trajectory(source);
        }

        @Override
        public Trajectory[] newArray(int size) {
            return new Trajectory[size];
        }
    };
}