package com.segway.robot.algo.dts;

/**
 * Callback interface for being notified that a new state of person detection
 */
public interface PersonDetectListener {
    /**
     * This method is called when one or more person is detected. If there is not person
     * detected, this method will not be called.
     *
     * @param person an array of person detected.
     */
    void onPersonDetected(DTSPerson[] person);

    /**
     * This method is called when an error is occurred while detecting
     * Detection timeout is one of the most common error
     *
     * @param errorCode code of error
     * @param message   message of error
     */
    void onPersonDetectionError(int errorCode, String message);
}
