package com.segway.robot.algo;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * PhysicalObject describe an object in the world at a certain time
 */
public class PhysicalObject extends Point3DF implements Parcelable{
    protected CubeF mBound;

    public PhysicalObject(float x, float y, float z, CubeF bound, long timeStamp) {
        super(x, y, z, timeStamp);
        mBound = bound;
    }

    /**
     * Get the bound of the object
     * @return the bound of the object
     */
    public CubeF getBound() {
        return mBound;
    }

    public static final Creator<PhysicalObject> CREATOR = new Creator<PhysicalObject>() {
        @Override
        public PhysicalObject createFromParcel(Parcel in) {
            long timestamp = in.readLong();
            float x = in.readFloat();
            float y = in.readFloat();
            float z = in.readFloat();
            CubeF cubeF = in.readParcelable(CubeF.class.getClassLoader());
            return new PhysicalObject(x, y, z, cubeF, timestamp);
        }

        @Override
        public PhysicalObject[] newArray(int size) {
            return new PhysicalObject[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(mTimeStamp);
        dest.writeFloat(mX);
        dest.writeFloat(mY);
        dest.writeFloat(mZ);
        dest.writeParcelable(mBound, flags);
    }
}
