/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.algo.minicontroller;

import com.segway.robot.algo.Pose2D;

public class VirtualMap {
    private Pose2D mOriginalOdometryPoint;

    public VirtualMap(Pose2D originalOdometryPoint) {
        this.mOriginalOdometryPoint = originalOdometryPoint;
    }

    public Pose2D mapToOdometry(float x, float y, float theta) {
        Pose2D pose2D = new Pose2D(x, y, theta, 0.0f, 0.0f, System.currentTimeMillis() * 1000L);
        return this.mapToOdometry(pose2D);
    }

    public Pose2D mapToOdometry(Pose2D virtualPose) {
        long timestamp = virtualPose.getTimestamp();
        double angle = this.diffAngle(this.mOriginalOdometryPoint.getTheta(), 0.0);
        double orient = this.plusAngle(virtualPose.getTheta(), angle);
        double x = (double)this.mOriginalOdometryPoint.getX() + (double)virtualPose.getX() * Math.cos(angle) - (double)virtualPose.getY() * Math.sin(angle);
        double y = (double)this.mOriginalOdometryPoint.getY() + (double)virtualPose.getX() * Math.sin(angle) + (double)virtualPose.getY() * Math.cos(angle);
        return new Pose2D((float)x, (float)y, (float)orient, 0.0f, 0.0f, timestamp);
    }

    public Pose2D mapToVirtual(float x, float y, float theta) {
        Pose2D pose2D = new Pose2D(x, y, theta, 0.0f, 0.0f, System.currentTimeMillis() * 1000L);
        return this.mapToVirtual(pose2D);
    }

    public Pose2D mapToVirtual(Pose2D odometryPose) {
        long timestamp = odometryPose.getTimestamp();
        double angle = this.diffAngle(0.0, this.mOriginalOdometryPoint.getTheta());
        double orient = this.diffAngle(angle, odometryPose.getTheta());
        double x = (double)(-this.mOriginalOdometryPoint.getX()) + (double)odometryPose.getX() * Math.cos(angle) - (double)odometryPose.getY() * Math.sin(angle);
        double y = (double)(-this.mOriginalOdometryPoint.getY()) + (double)odometryPose.getX() * Math.sin(angle) + (double)odometryPose.getY() * Math.cos(angle);
        return new Pose2D((float)x, (float)y, (float)orient, 0.0f, 0.0f, timestamp);
    }

    private double diffAngle(double from, double to) {
        double angle = from - to;
        if (angle > Math.PI) {
            angle = Math.PI * 2 - angle;
        }
        if (angle < -Math.PI) {
            angle = Math.PI * 2 + angle;
        }
        return (float)angle;
    }

    private double plusAngle(double from, double to) {
        double angle = from + to;
        if (angle > Math.PI) {
            angle = Math.PI * 2 - angle;
        }
        if (angle < -Math.PI) {
            angle = Math.PI * 2 + angle;
        }
        return (float)angle;
    }
}

