package com.segway.robot.algo.tf;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by Yusen.QIN on 2017/10/16.
 */

public class AlgoTfData implements Parcelable {
    public String tgtFrameID;
    public String srcFrameID;
    public long timeStamp;
    public Quaternion q;
    public Translation t;
    int err_code;

    protected AlgoTfData(Parcel in) {
        tgtFrameID = in.readString();
        srcFrameID = in.readString();
        timeStamp = in.readLong();
        err_code = in.readInt();
        q = in.readParcelable(Quaternion.class.getClassLoader());
        t = in.readParcelable(Translation.class.getClassLoader());
    }

    public static final Creator<AlgoTfData> CREATOR = new Creator<AlgoTfData>() {
        @Override
        public AlgoTfData createFromParcel(Parcel in) {
            return new AlgoTfData(in);
        }

        @Override
        public AlgoTfData[] newArray(int size) {
            return new AlgoTfData[size];
        }
    };

    public AlgoTfData set(String tgtID, String srcID, long timeStamp, Quaternion q, Translation t, int err){
        this.tgtFrameID = tgtID;
        this.srcFrameID = srcID;
        this.timeStamp = timeStamp;
        this.err_code = err;
        this.q = q;
        this.t = t;
        return this;
    }
    public  AlgoTfData (String tgtID, String srcID, long timeStamp, Quaternion q, Translation t){
        this.set(tgtID,srcID,timeStamp,q,t,0);
    }
    public  AlgoTfData (String tgtID, String srcID, long timeStamp, Quaternion q, Translation t, int err){
        this.set(tgtID,srcID,timeStamp,q,t,err);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(tgtFrameID);
        dest.writeString(srcFrameID);
        dest.writeLong(timeStamp);
        dest.writeInt(err_code);
        dest.writeParcelable(q, flags);
        dest.writeParcelable(t, flags);
    }

    @Override
    public String toString() {
        return "AlgoTfData{" +
                ", tgtFrameID='" + tgtFrameID + '\'' +
                "srcFrameID='" + srcFrameID + '\'' +
                ", timeStamp=" + timeStamp +
                ", q=" + q +
                ", t=" + t +
                ", err_code=" + err_code +
                '}';
    }
}
