package com.segway.robot.algo;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * CubeF describe the length, width and height of an object
 */
public class CubeF implements Parcelable{
    private float mWidth;
    private float mDepth;
    private float mHeight;

    /**
     * Construct a new instance with width, depth and height
     * @param width the width of the object
     * @param depth the depth of the object
     * @param height the height of the object
     */
    public CubeF(float width, float depth, float height) {
        mWidth = width;
        mDepth = depth;
        mHeight = height;
    }

    protected CubeF(Parcel in) {
        mWidth = in.readFloat();
        mDepth = in.readFloat();
        mHeight = in.readFloat();
    }

    public static final Creator<CubeF> CREATOR = new Creator<CubeF>() {
        @Override
        public CubeF createFromParcel(Parcel in) {
            return new CubeF(in);
        }

        @Override
        public CubeF[] newArray(int size) {
            return new CubeF[size];
        }
    };

    /**
     * Get the width of the object
     * @return width
     */
    public float getWidth() {
        return mWidth;
    }

    /**
     * Get the depth of the object
     * @return depth
     */
    public float getDepth() {
        return mDepth;
    }

    /**
     * Get the height of the object
     * @return height
     */
    public float getHeight() {
        return mHeight;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(mWidth);
        dest.writeFloat(mDepth);
        dest.writeFloat(mHeight);
    }
}
