/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.algo.tf;

import android.os.Parcel;
import android.os.Parcelable;
import com.segway.robot.algo.tf.MathUtils;

public class Quaternion
implements Parcelable {
    public float x;
    public float y;
    public float z;
    public float w;
    public static final Parcelable.Creator<Quaternion> CREATOR = new Parcelable.Creator<Quaternion>(){

        public Quaternion createFromParcel(Parcel in) {
            return new Quaternion(in);
        }

        public Quaternion[] newArray(int size) {
            return new Quaternion[size];
        }
    };

    protected Quaternion(Parcel in) {
        this.x = in.readFloat();
        this.y = in.readFloat();
        this.z = in.readFloat();
        this.w = in.readFloat();
    }

    public Quaternion set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public Quaternion(float x, float y, float z, float w) {
        this.set(x, y, z, w);
    }

    public Quaternion set(Quaternion quaternion) {
        return this.set(quaternion.x, quaternion.y, quaternion.z, quaternion.w);
    }

    public int getGimbalPole() {
        float t = this.y * this.x + this.z * this.w;
        if (t > 0.49999f) {
            return 1;
        }
        if (t < -0.49999f) {
            return -1;
        }
        return 0;
    }

    public float getRollRad() {
        int pole = this.getGimbalPole();
        if (pole == 0) {
            return MathUtils.atan2(2.0f * (this.w * this.z + this.y * this.x), 1.0f - 2.0f * (this.x * this.x + this.z * this.z));
        }
        return (float)pole * 2.0f * MathUtils.atan2(this.y, this.w);
    }

    public float getPitchRad() {
        int pole = this.getGimbalPole();
        return pole == 0 ? (float)Math.asin(MathUtils.clamp(2.0f * (this.w * this.x - this.z * this.y), -1.0f, 1.0f)) : (float)pole * (float)Math.PI * 0.5f;
    }

    public float getYawRad() {
        return this.getGimbalPole() == 0 ? MathUtils.atan2(2.0f * (this.y * this.w + this.x * this.z), 1.0f - 2.0f * (this.y * this.y + this.x * this.x)) : 0.0f;
    }

    public float getDegreeFromRadians(float degree) {
        return degree * 57.295776f;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(this.x);
        dest.writeFloat(this.y);
        dest.writeFloat(this.z);
        dest.writeFloat(this.w);
    }

    public String toString() {
        return "Quaternion{x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", w=" + this.w + '}';
    }
}

