package com.segway.robot.algo.tf;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Created by Yusen.QIN on 2017/10/16.
 */

public class AlgoTfData implements Parcelable {
    public String srcFrameID;
    public String tgtFrameID;
    public long timeStamp;
    public Quaternion q;
    public Translation t;
    int err_code;

    protected AlgoTfData(Parcel in) {
        srcFrameID = in.readString();
        tgtFrameID = in.readString();
        timeStamp = in.readLong();
        err_code = in.readInt();
        q = in.readParcelable(Quaternion.class.getClassLoader());
        t = in.readParcelable(Translation.class.getClassLoader());
    }

    public static final Creator<AlgoTfData> CREATOR = new Creator<AlgoTfData>() {
        @Override
        public AlgoTfData createFromParcel(Parcel in) {
            return new AlgoTfData(in);
        }

        @Override
        public AlgoTfData[] newArray(int size) {
            return new AlgoTfData[size];
        }
    };

    public AlgoTfData set(String srcID, String tgtID, long timeStamp, Quaternion q, Translation t, int err){
        this.srcFrameID = srcID;
        this.tgtFrameID = tgtID;
        this.timeStamp = timeStamp;
        this.err_code = err;
        this.q = q;
        this.t = t;
        return this;
    }
    public  AlgoTfData (String srcID, String tgtID, long timeStamp, Quaternion q, Translation t){
        this.set(srcID,tgtID,timeStamp,q,t,0);
    }
    public  AlgoTfData (String srcID, String tgtID, long timeStamp, Quaternion q, Translation t, int err){
        this.set(srcID,tgtID,timeStamp,q,t,err);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(srcFrameID);
        dest.writeString(tgtFrameID);
        dest.writeLong(timeStamp);
        dest.writeInt(err_code);
        dest.writeParcelable(q, flags);
        dest.writeParcelable(t, flags);
    }

    @Override
    public String toString() {
        return "AlgoTfData{" +
                "srcFrameID='" + srcFrameID + '\'' +
                ", tgtFrameID='" + tgtFrameID + '\'' +
                ", timeStamp=" + timeStamp +
                ", q=" + q +
                ", t=" + t +
                ", err_code=" + err_code +
                '}';
    }
}
