package com.segway.robot.algo;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * Odometry pose provides an estimated robot pose (x, y, orientation) relative to a starti ng pose.
 * The origin of the coordinate frame is the x, y center of the base assembly,
 * with z on the ground and theta to the front.
 */

public class Pose2D extends Point2DF {
    private final float mTheta;
    private final float mLinearVelocity;
    private final float mAngularVelocity;

    public Pose2D(float x, float y, float theta, float linearVelocity, float angularVelocity, long timeStamp) {
        super(x, y, timeStamp);
        mTheta = theta;
        mLinearVelocity = linearVelocity;
        mAngularVelocity = angularVelocity;
    }

    /**
     * Get the theta of the pose
     * @return the theta of the pose
     */
    public float getTheta() {
        return mTheta;
    }

    /**
     * Get the linear velocity
     * @return linear velocity
     */
    public float getLinearVelocity() {
        return mLinearVelocity;
    }

    /**
     * Get the angular velocity
     * @return angular velocity
     */
    public float getAngularVelocity() {
        return mAngularVelocity;
    }

    @Override
    public String toString() {
        return "Pose2D: x=" + getX() + " y=" + getY() + " theta=" + getTheta()
                + " linearVelocity=" + getLinearVelocity() + " angularVelocity=" + getAngularVelocity()
                + " timestamp=" + getTimestamp();
    }

    public static final Parcelable.Creator<Pose2D> CREATOR = new Parcelable.Creator<Pose2D>() {
        @Override
        public Pose2D createFromParcel(Parcel in) {
            long timestamp = in.readLong();
            float x = in.readFloat();
            float y = in.readFloat();
            float theta = in.readFloat();
            float linearVelocity = in.readFloat();
            float angularVelocity = in.readFloat();
            return new Pose2D(x, y, theta, linearVelocity, angularVelocity, timestamp);
        }

        @Override
        public Pose2D[] newArray(int size) {
            return new Pose2D[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(mTimeStamp);
        dest.writeFloat(mX);
        dest.writeFloat(mY);
        dest.writeFloat(mTheta);
        dest.writeFloat(mLinearVelocity);
        dest.writeFloat(mAngularVelocity);
    }
}
