/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.baseconnectivity;

import android.util.Log;
import java.nio.ByteBuffer;

public class ByteMessage {
    private static final String TAG = "ByteMessage";
    private static final int ID_SIZE = 4;
    private static final int TIMESTAMP_SIZE = 8;
    private static final int FROM_SIZE = 4;
    private static final int TO_SIZE = 4;
    private static final int MESSAGE_SIZE = 4;
    public int mId;
    public long mTimestamp;
    public String mFrom;
    public String mTo;
    public byte[] mMessage;

    public ByteMessage(int id, long timestamp, String from, String to, byte[] message) {
        this.mId = id;
        this.mTimestamp = timestamp;
        this.mFrom = from;
        this.mTo = to;
        this.mMessage = message;
    }

    public ByteMessage() {
    }

    public void unpackMessage(byte[] message, ByteMessage byteMessage) {
        ByteBuffer buffer = ByteBuffer.wrap(message);
        int id = buffer.getInt();
        long timestamp = buffer.getLong();
        int fromLength = buffer.getInt();
        byte[] fromByte = new byte[fromLength];
        int toLength = buffer.getInt();
        byte[] toByte = new byte[toLength];
        int messageLength = buffer.getInt();
        byte[] messageByte = new byte[messageLength];
        int i = 0;
        while (buffer.hasRemaining()) {
            fromByte[i] = buffer.get();
            if (++i != fromLength) continue;
        }
        String from = new String(fromByte);
        i = 0;
        while (buffer.hasRemaining()) {
            toByte[i] = buffer.get();
            if (++i != toLength) continue;
        }
        String to = new String(toByte);
        i = 0;
        while (buffer.hasRemaining()) {
            messageByte[i] = buffer.get();
            if (++i != messageLength) continue;
        }
        Log.d((String)TAG, (String)("id=" + id + ";timestamp=" + timestamp + ";from=" + from + ";to=" + to + ";m-length=" + messageLength + ";a-length=" + message.length));
        byteMessage.mId = id;
        byteMessage.mTimestamp = timestamp;
        byteMessage.mFrom = from;
        byteMessage.mTo = to;
        byteMessage.mMessage = messageByte;
    }

    public byte[] packByteMessage(ByteMessage byteMessage) {
        int id = byteMessage.mId;
        long timestamp = byteMessage.mTimestamp;
        byte[] fromByte = byteMessage.mFrom.getBytes();
        int fromLength = fromByte.length;
        byte[] destByte = byteMessage.mTo.getBytes();
        int destLength = destByte.length;
        byte[] messageByte = byteMessage.mMessage;
        int messageLength = messageByte.length;
        ByteBuffer buffer = ByteBuffer.allocate(24 + fromLength + destLength + messageLength);
        buffer.putInt(id);
        buffer.putLong(timestamp);
        buffer.putInt(fromLength);
        buffer.putInt(destLength);
        buffer.putInt(messageLength);
        buffer.put(fromByte);
        buffer.put(destByte);
        buffer.put(messageByte);
        byte[] bufferMessage = buffer.array();
        Log.d((String)TAG, (String)("id=" + id + ";timestamp=" + timestamp + ";from=" + byteMessage.mFrom + ";to=" + byteMessage.mTo + ";mmLength=" + messageLength + ";al-Length=" + bufferMessage.length));
        return bufferMessage;
    }
}

