package com.segway.robot.sdk.baseconnectivity;

import android.util.Log;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Created by gaofeng on 2016/9/21.
 */
public class MessageUtil {
    private static final String TAG = "MessageUtil";
    public static final String MSG_FROM = "from";
    public static final String MSG_TO = "to";
    public static final String MSG_BODY = "msg_body";
    public static final String MSG_ID = "msg_id";
    public static final String TIMESTAMP = "timestamp";

    public static final String ADD_NEW = "ACTION.ADD_NEW";
    public static final String REMOVE_HOST = "ACTION.REMOVE_HOST";
    public static final String UPDATE_LIST = "ACTION.UPDATE_ROBOT_LIST";
    public static final String REMOVE_DEAD = "ACTION.REMOVE_DEAD";
    public static final String MESSAGE_LISTENER_READY = "ACTION.MESSAGE_LISTENER_READY";
    public static final String SESSION_OPEN = "ACTION.SESSION_OPEN";
    public static final String REPEATED_CONNECTION = "ACTION.REPEATED_CONNECTION";

    public static final int MAX_BUFFER_LENGTH = 1000 * 1024;//1M
    public static final int MAX_CODER_LENGTH = 2 * 1024 * 1024;//2M
    public static final int HEART_BEAT_INTERVAL = 15;//15s
    public static final int HEART_BEAT_TIMEOUT = 5;//5s
    public static final int WRITE_TIMEOUT = 5;//5s

    public static final String MOBILE_HEARTBEAT_REQUEST = "{\"mobile\":\"heartbeat request\"}";
    public static final String MOBILE_HEARTBEAT_RESPONSE = "{\"mobile\":\"heartbeat response\"}";
    public static final String ROBOT_HEARTBEAT_REQUEST = "{\"robot\":\"heartbeat request\"}";
    public static final String ROBOT_HEARTBEAT_RESPONSE = "{\"robot\":\"heartbeat response\"}";

    private MessageUtil() {
        throw new IllegalAccessError("Utility class");
    }

    public static Set packMetaDataToSet(String data) {
        Set<String> set = new HashSet<>();
        String[] strings = data.split(",");
        for (int i = 0; i < strings.length; i++) {
            set.add(strings[i].replace(" ", ""));
        }
        return set;
    }

    public static JSONObject packListToJson(List<ConnectionInfo> list) {
        JSONObject json = new JSONObject();
        for (ConnectionInfo info : list) {
            if (info != null) {
                try {
                    json.put(info.getPackageName(), info.getMetadata().toString());
                } catch (JSONException e) {
                    Log.e(TAG, "packListToJson: message is not json");
                }
            }
        }
        return json;
    }

    /**
     * Get timestamp.
     *
     * @return timestamp
     */
    public static long getTimestamp() {
        return System.currentTimeMillis();
    }

    /**
     * Pack Set to String.
     *
     * @param set the Set to be packed to String.
     * @return the String to be packed to.
     */
    public static String packSetToString(Set<String> set) {
        if (set != null) {
            return set.toString().replace("[", "").replace("]", "").replace(" ", "");
        }
        return null;
    }

    /**
     * Pack JSONObject to Map.
     *
     * @param jsonObject the JSONObject to be packed to Map.
     * @return Map the Map to be packed to.
     */
    public static Map packJsonToMap(JSONObject jsonObject) {
        Map<String, String> dataMap = new HashMap<>();
        Iterator<String> iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String key = iterator.next();
            try {
                dataMap.put(key, jsonObject.getString(key));
            } catch (JSONException e) {
                // TODO: 2016/9/21 catch exception
                e.printStackTrace();
            }
        }
        return dataMap;
    }
}