package com.segway.robot.sdk.baseconnectivity;

/**
 * Message to be sent when {@link MessageConnection} is created. It is a base class for {@code BufferMessage}
 * and {@code StringMessage} implementations. It is recommended that when sending messages,
 * use BufferMessage/StringMessage instead of using Message directly.
 *
 * @param <T> the message content which can be byte[] or String.
 */
public class Message<T> {

    private T mContent;
    private long mTimestamp = 0;
    private static int mId = 0;

    /**
     * Create an empty {@code Message}.
     */
    public Message() {
        mId++;
    }

    protected Message(long timestamp, T content, int id) {
        mTimestamp = timestamp;
        mContent = content;
        mId = id;
    }

    /**
     * Create an empty {@code Message} with the message content initialized.
     *
     * @param content the content of the Message to be sent.
     */
    public Message(T content) {
        mId++;
        mContent = content;
    }

    /**
     * Get the message ID.
     *
     * @return the ID of the Message to be sent.
     */
    public int getId() {
        return mId;
    }

    /**
     * Get the timestamp when the Message is sent.
     *
     * @return the timestamp when the Message is sent.
     */
    public long getTimestampSent() {
        return mTimestamp;
    }

    /**
     * Set the message content.
     *
     * @param message the content of the message to be set for Message.
     */
    public void setContent(T message) {
        mContent = message;
    }

    /**
     * Get the message content.
     *
     * @return the content of the Message which can be byte[] or String.
     */
    public T getContent() {
        return mContent;
    }
}
