package com.segway.robot.sdk.baseconnectivity;

import android.content.Context;

import com.segway.robot.sdk.base.bind.ServiceBinder;

/**
 * This class provides methods for the applications to register/unregister and bind to/unbind from the
 * connection service in the robot. It is a base class for {@code MobileMessageRouter} and {@code RobotMessageRouter}
 * implementations. It is recommended to use MobileMessageRouter in mobile applications and RobotMessageRouter
 * in robot applications.
 */
public abstract class MessageRouter implements ServiceBinder {

    /**
     * Register a {@link MessageConnectionListener} in the message handler.
     *
     * @param messageConnectionListener the MessageConnectionListener to be registered.
     * @throws Exception Throw the exception if an exception occurs when registering the listener.
     */
    public abstract void register(MessageConnectionListener messageConnectionListener) throws Exception ;

    /**
     * Unregister the MessageConnectionListener.
     */
    public abstract void unregister() throws Exception ;

    public abstract boolean isRegistered();

    /**
     * Bind to the robot connection service.
     *
     * @param context  any Android context
     * @param listener the BindStateLister to be used to listen to the bind state of the connection service.
     * @return default return false.
     */
    @Override
    public boolean bindService(Context context, BindStateListener listener) {
        return false;
    }

    /**
     * Unbind from the robot connection service.
     */
    @Override
    public void unbindService() {

    }

    /**
     * Get the state of binding service.
     * @return false default.
     */
    @Override
    public boolean isBind() {
        return false;
    }

    /**
     * Get the BindStateListener.
     *
     * @return default return null.
     */
    @Override
    public BindStateListener getBindStateListener() {
        return null;
    }

    /**
     * This interface provides callback for the {@link MessageConnection} when it is created.
     */
    public interface MessageConnectionListener {
        /**
         * This method is called when the MessageConnection is created successfully.
         *
         * @param connection the instance of MessageConnection.
         */
        void onConnectionCreated(MessageConnection connection);
    }
}
