package com.segway.robot.sdk.baseconnectivity.codec;

import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.baseconnectivity.MessageUtil;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderAdapter;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.serialization.ObjectSerializationDecoder;
import org.apache.mina.filter.codec.textline.TextLineDecoder;

public class CustomizeDecoder extends ProtocolDecoderAdapter {
    private static final String TAG = "CustomizeDecoder";
    private final TextLineDecoder mTextLineDecoder = new TextLineDecoder(MessageUtil.CHARSET_UTF_8);
    private final ObjectSerializationDecoder mObjectDecoder = new ObjectSerializationDecoder();

    public CustomizeDecoder() {
        mTextLineDecoder.setMaxLineLength(MessageUtil.MAX_TEXT_LINE_LENGTH);
        mObjectDecoder.setMaxObjectSize(MessageUtil.MAX_CODER_LENGTH);
    }

    @Override
    public void decode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        try {
            mObjectDecoder.decode(session, in, out);
            Logger.v(TAG, "decode: ObjectSerializationDecoder decode");
        } catch (Exception e) {
            Logger.v(TAG, "decode: error for debug", e);
            mTextLineDecoder.decode(session, in, out);
            Logger.v(TAG, "decode: TextLineDecoder decode");
        }
    }

    @Override
    public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
        super.finishDecode(session, out);
        Logger.v(TAG, "finishDecode");
    }

}
