package com.segway.robot.sdk.baseconnectivity;

import com.segway.robot.sdk.base.log.Logger;

import java.nio.ByteBuffer;

/**
 * Created by gaofeng on 2016/9/22.
 */
public class ByteMessage {
    private static final String TAG = "ByteMessage";
    private static final int ID_SIZE = 4;
    private static final int TIMESTAMP_SIZE = 8;
    private static final int FROM_SIZE = 4;
    private static final int TO_SIZE = 4;
    private static final int MESSAGE_SIZE = 4;

    public int mId;
    public long mTimestamp;
    public String mFrom;
    public String mTo;
    public byte[] mMessage;

    public ByteMessage(int id, long timestamp, String from, String to, byte[] message) {
        this.mId = id;
        this.mTimestamp = timestamp;
        this.mFrom = from;
        this.mTo = to;
        this.mMessage = message;
    }

    public ByteMessage() {
    }

    /**
     * Unpack the byte[] to ByteMessage.
     * @param message the byte array of the message to be unpacked.
     * @param byteMessage the ByteMessage to be unpacked to.
     */
    public void unpackMessage(byte[] message, ByteMessage byteMessage) {
        ByteBuffer buffer = ByteBuffer.wrap(message);
        int id = buffer.getInt();
        long timestamp = buffer.getLong();
        int fromLength = buffer.getInt();
        byte[] fromByte = new byte[fromLength];
        int toLength = buffer.getInt();
        byte[] toByte = new byte[toLength];
        int messageLength = buffer.getInt();
        byte[] messageByte = new byte[messageLength];
        int i = 0;
        while (buffer.hasRemaining()) {
            fromByte[i] = buffer.get();
            i++;
            if (i == fromLength) {
                break;
            }
        }
        String from = new String(fromByte);
        i = 0;
        while (buffer.hasRemaining()) {
            toByte[i] = buffer.get();
            i++;
            if (i == toLength) {
                break;
            }
        }
        String to = new String(toByte);
        i = 0;
        while (buffer.hasRemaining()) {
            messageByte[i] = buffer.get();
            i++;
            if (i == messageLength) {
                break;
            }
        }
        Logger.d(TAG, "id=" + id + ";timestamp=" + timestamp + ";from=" + from + ";to=" + to + ";m-length=" + messageLength + ";a-length=" + message.length);
        byteMessage.mId = id;
        byteMessage.mTimestamp = timestamp;
        byteMessage.mFrom = from;
        byteMessage.mTo = to;
        byteMessage.mMessage = messageByte;
    }

    /**
     * Pack ByteMessage to byte[].
     * @param byteMessage the ByteMessage to be packed to byte array.
     * @return the byte array of the message.
     */
    public byte[] packByteMessage(ByteMessage byteMessage) {
        int id = byteMessage.mId;
        long timestamp = byteMessage.mTimestamp;
        byte[] fromByte = byteMessage.mFrom.getBytes();
        int fromLength = fromByte.length;
        byte[] destByte = byteMessage.mTo.getBytes();
        int destLength = destByte.length;
        byte[] messageByte = byteMessage.mMessage;
        int messageLength = messageByte.length;
        ByteBuffer buffer = ByteBuffer.allocate(ID_SIZE + TIMESTAMP_SIZE + FROM_SIZE + TO_SIZE + MESSAGE_SIZE + fromLength + destLength + messageLength);
        buffer.putInt(id);
        buffer.putLong(timestamp);
        buffer.putInt(fromLength);
        buffer.putInt(destLength);
        buffer.putInt(messageLength);
        buffer.put(fromByte);
        buffer.put(destByte);
        buffer.put(messageByte);
        byte[] bufferMessage = buffer.array();
        Logger.d(TAG, "id=" + id + ";timestamp=" + timestamp + ";from=" + byteMessage.mFrom + ";to=" + byteMessage.mTo + ";mmLength=" + messageLength + ";al-Length=" + bufferMessage.length);
        return bufferMessage;
    }
}

