/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.baseconnectivity;

import com.segway.robot.sdk.base.time.StampedData;

public class Message<T>
implements StampedData {
    private T mContent;
    private long mTimestamp = 0L;
    private static int mId = 0;

    public Message() {
        Message.createId();
    }

    protected Message(long timestamp, T content, int id) {
        this.mTimestamp = timestamp;
        this.mContent = content;
        mId = id;
    }

    public Message(T content) {
        Message.createId();
        this.mContent = content;
    }

    public int getId() {
        return mId;
    }

    public long getTimestamp() {
        return this.mTimestamp;
    }

    public void setContent(T message) {
        this.mContent = message;
    }

    public T getContent() {
        return this.mContent;
    }

    private static synchronized long createId() {
        return ++mId;
    }

    public long diff(StampedData source) {
        if (source == null) {
            throw new IllegalArgumentException("StampedData can't be null!");
        }
        return this.mTimestamp - source.getTimestamp();
    }
}

