/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.baseconnectivity.codec;

import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.baseconnectivity.MessageUtil;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderAdapter;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.serialization.ObjectSerializationDecoder;
import org.apache.mina.filter.codec.textline.TextLineDecoder;

public class CustomizeDecoder
extends ProtocolDecoderAdapter {
    private static final String TAG = "CustomizeDecoder";
    private final TextLineDecoder mTextLineDecoder = new TextLineDecoder(MessageUtil.CHARSET_UTF_8);
    private final ObjectSerializationDecoder mObjectDecoder = new ObjectSerializationDecoder();

    public CustomizeDecoder() {
        this.mTextLineDecoder.setMaxLineLength(0x200000);
        this.mObjectDecoder.setMaxObjectSize(0x200000);
    }

    public void decode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        try {
            this.mObjectDecoder.decode(session, in, out);
            Logger.v((String)TAG, (String)"decode: ObjectSerializationDecoder decode");
        }
        catch (Exception e) {
            Logger.v((String)TAG, (String)"decode: TextLineDecoder, error for debug", (Throwable)e);
            this.mTextLineDecoder.decode(session, in, out);
            Logger.v((String)TAG, (String)"decode: TextLineDecoder decode");
        }
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
        super.finishDecode(session, out);
        Logger.v((String)TAG, (String)"finishDecode");
    }
}

