/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.baseconnectivity;

import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.baseconnectivity.ConnectionInfo;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageUtil {
    private static final String TAG = "MessageUtil";
    public static final String MSG_FROM = "from";
    public static final String MSG_TO = "to";
    public static final String MSG_BODY = "msg_body";
    public static final String MSG_ID = "msg_id";
    public static final String TIMESTAMP = "timestamp";
    public static final String ADD_NEW = "ACTION.ADD_NEW";
    public static final String REMOVE_HOST = "ACTION.REMOVE_HOST";
    public static final String UPDATE_LIST = "ACTION.UPDATE_ROBOT_LIST";
    public static final String REMOVE_DEAD = "ACTION.REMOVE_DEAD";
    public static final String MESSAGE_LISTENER_READY = "ACTION.MESSAGE_LISTENER_READY";
    public static final String SESSION_OPEN = "ACTION.SESSION_OPEN";
    public static final String REPEATED_CONNECTION = "ACTION.REPEATED_CONNECTION";
    public static final String MOBILE_UNBIND = "ACTION.MOBILE_UNBIND";
    public static final int MAX_BUFFER_LENGTH = 1024000;
    public static final int MAX_STRING_LENGTH = 460800;
    public static final int MAX_CODER_LENGTH = 0x200000;
    public static final int MAX_TEXT_LINE_LENGTH = 0x200000;
    public static final int HEART_BEAT_INTERVAL = 10;
    public static final int HEART_BEAT_TIMEOUT = 5;
    public static final int WRITE_TIMEOUT = 5;
    public static final String MOBILE_HEARTBEAT_REQUEST = "{\"mobile\":\"heartbeat request\"}";
    public static final String MOBILE_HEARTBEAT_RESPONSE = "{\"mobile\":\"heartbeat response\"}";
    public static final String ROBOT_HEARTBEAT_REQUEST = "{\"robot\":\"heartbeat request\"}";
    public static final String ROBOT_HEARTBEAT_RESPONSE = "{\"robot\":\"heartbeat response\"}";
    public static final String UTF_8 = "UTF-8";
    public static final Charset CHARSET_UTF_8 = StandardCharsets.UTF_8;

    private MessageUtil() {
        throw new IllegalAccessError("Utility class");
    }

    public static Set packMetaDataToSet(String data) {
        if (data == null || data.length() == 0) {
            throw new IllegalArgumentException("String can't be null!");
        }
        HashSet<String> set = new HashSet<String>();
        String[] strings = data.split(",");
        for (int i = 0; i < strings.length; ++i) {
            set.add(strings[i].replace(" ", ""));
        }
        return set;
    }

    public static JSONObject packListToJson(List<ConnectionInfo> list) {
        if (list == null) {
            throw new IllegalArgumentException("List can't be null!");
        }
        JSONObject json = new JSONObject();
        for (ConnectionInfo info : list) {
            if (info == null) continue;
            try {
                json.put(info.getPackageName(), (Object)info.getMetadata().toString());
            }
            catch (JSONException e) {
                Logger.e((String)TAG, (String)"packListToJson: ", (Throwable)e);
            }
        }
        return json;
    }

    public static long getTimestamp() {
        return System.currentTimeMillis() * 1000L;
    }

    public static String packSetToString(Set<String> set) {
        if (set == null) {
            throw new IllegalArgumentException("Set can't be null");
        }
        return set.toString().replace("[", "").replace("]", "").replace(" ", "");
    }

    public static Map packJsonToMap(JSONObject jsonObject) {
        if (jsonObject == null) {
            throw new IllegalArgumentException("JSONObject can't be null!");
        }
        ConcurrentHashMap<String, String> dataMap = new ConcurrentHashMap<String, String>();
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            try {
                dataMap.put(key, jsonObject.getString(key));
            }
            catch (JSONException e) {
                Logger.e((String)TAG, (String)"packJsonToMap: ", (Throwable)e);
            }
        }
        return dataMap;
    }
}

