/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.baseconnectivity.codec;

import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.baseconnectivity.MessageUtil;
import java.io.Serializable;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoderAdapter;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.filter.codec.serialization.ObjectSerializationEncoder;
import org.apache.mina.filter.codec.textline.TextLineEncoder;

public class CustomizeEncoder
extends ProtocolEncoderAdapter {
    private static final String TAG = "CustomizeEncoder";
    private final TextLineEncoder mTextLineEncoder = new TextLineEncoder(MessageUtil.CHARSET_UTF_8);
    private final ObjectSerializationEncoder mObjectEncoder = new ObjectSerializationEncoder();

    public CustomizeEncoder() {
        this.mTextLineEncoder.setMaxLineLength(0x200000);
        this.mObjectEncoder.setMaxObjectSize(0x200000);
    }

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        if (message instanceof String) {
            this.mTextLineEncoder.encode(session, message, out);
            Logger.v((String)TAG, (String)"encode: TextLineDecoder encode");
            return;
        }
        if (message instanceof Serializable) {
            this.mObjectEncoder.encode(session, message, out);
            Logger.v((String)TAG, (String)"encode: ObjectSerializationEncoder encode");
        }
    }
}

