package com.segway.robot.sdk.baseconnectivity.codec;

import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.baseconnectivity.MessageUtil;

import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoderAdapter;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.filter.codec.serialization.ObjectSerializationEncoder;
import org.apache.mina.filter.codec.textline.TextLineEncoder;

import java.io.Serializable;

public class CustomizeEncoder extends ProtocolEncoderAdapter {
    private static final String TAG = "CustomizeEncoder";
    private final TextLineEncoder mTextLineEncoder = new TextLineEncoder(MessageUtil.CHARSET_UTF_8);
    private final ObjectSerializationEncoder mObjectEncoder = new ObjectSerializationEncoder();

    public CustomizeEncoder() {
        mTextLineEncoder.setMaxLineLength(MessageUtil.MAX_TEXT_LINE_LENGTH);
        mObjectEncoder.setMaxObjectSize(MessageUtil.MAX_CODER_LENGTH);
    }

    @Override
    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        if (message instanceof String) {
            mTextLineEncoder.encode(session, message, out);
            Logger.v(TAG, "encode: TextLineDecoder encode");
            return;
        }

        if (message instanceof Serializable) {
            mObjectEncoder.encode(session, message, out);
            Logger.v(TAG, "encode: ObjectSerializationEncoder encode");
        }
    }

}
