/*
 * Decompiled with CFR 0.152.
 */
package com.segment.analytics.internal.integrations;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import com.bugsnag.android.Bugsnag;
import com.bugsnag.android.Client;
import com.segment.analytics.Analytics;
import com.segment.analytics.Traits;
import com.segment.analytics.ValueMap;
import com.segment.analytics.internal.AbstractIntegration;
import com.segment.analytics.internal.model.payloads.IdentifyPayload;
import com.segment.analytics.internal.model.payloads.ScreenPayload;
import com.segment.analytics.internal.model.payloads.TrackPayload;
import java.util.Map;

public class BugsnagIntegration
extends AbstractIntegration<Client> {
    static final String BUGSNAG_KEY = "Bugsnag";

    public void initialize(Context context, ValueMap settings, Analytics.LogLevel logLevel) throws IllegalStateException {
        Bugsnag.init((Context)context, (String)settings.getString("apiKey"));
    }

    public Client getUnderlyingInstance() {
        return Bugsnag.getClient();
    }

    public String key() {
        return BUGSNAG_KEY;
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        super.onActivityCreated(activity, savedInstanceState);
        Bugsnag.setContext((String)activity.getLocalClassName());
    }

    public void identify(IdentifyPayload identify) {
        super.identify(identify);
        Traits traits = identify.traits();
        Bugsnag.setUser((String)traits.userId(), (String)traits.email(), (String)traits.name());
        String userKey = "User";
        for (Map.Entry entry : traits.entrySet()) {
            Bugsnag.addToTab((String)"User", (String)((String)entry.getKey()), entry.getValue());
        }
    }

    public void screen(ScreenPayload screen) {
        super.screen(screen);
        Bugsnag.leaveBreadcrumb((String)String.format("Viewed %s Screen", screen.event()));
    }

    public void track(TrackPayload track) {
        super.track(track);
        Bugsnag.leaveBreadcrumb((String)track.event());
    }
}

