/*
 * Decompiled with CFR 0.152.
 */
package com.sebchlan.picassocompat;

import android.app.Notification;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.widget.ImageView;
import android.widget.RemoteViews;
import com.jakewharton.picasso.OkHttp3Downloader;
import com.sebchlan.picassocompat.CallbackCompat;
import com.sebchlan.picassocompat.PicassoCompat;
import com.sebchlan.picassocompat.RequestCreatorCompat;
import com.sebchlan.picassocompat.TargetCompat;
import com.sebchlan.picassocompat.TransformationCompat;
import com.squareup.picasso.Callback;
import com.squareup.picasso.Downloader;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.RequestCreator;
import com.squareup.picasso.Target;
import com.squareup.picasso.Transformation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import okhttp3.Call;
import okhttp3.OkHttpClient;

public class PicassoCompat252
implements PicassoCompat {
    private final Map<TargetCompat, Target> targetMap = new HashMap<TargetCompat, Target>();
    private final Picasso picasso;

    private PicassoCompat252(Picasso picasso) {
        this.picasso = picasso;
    }

    PicassoCompat252(Context context) {
        this(Picasso.with((Context)context));
    }

    public void cancelRequest(@NonNull ImageView view) {
        this.picasso.cancelRequest(view);
    }

    public void cancelRequest(@NonNull TargetCompat targetCompat) {
        if (this.targetMap.containsKey(targetCompat)) {
            this.picasso.cancelRequest(this.targetMap.get(targetCompat));
        }
    }

    public void cancelTag(@NonNull Object tag) {
        this.picasso.cancelTag(tag);
    }

    public void pauseTag(@NonNull Object tag) {
        this.picasso.pauseTag(tag);
    }

    public void resumeTag(@NonNull Object tag) {
        this.picasso.resumeTag(tag);
    }

    public RequestCreatorCompat load(@Nullable Uri uri) {
        return new RequestCreatorCompat252(this.picasso, uri);
    }

    public RequestCreatorCompat load(@Nullable String path) {
        return new RequestCreatorCompat252(this.picasso, path);
    }

    public RequestCreatorCompat load(@Nullable File file) {
        return new RequestCreatorCompat252(this.picasso, file);
    }

    public RequestCreatorCompat load(int resourceId) {
        return new RequestCreatorCompat252(this.picasso, resourceId);
    }

    public void invalidate(@Nullable Uri uri) {
        this.picasso.invalidate(uri);
    }

    public void invalidate(@Nullable String path) {
        this.picasso.invalidate(path);
    }

    public void invalidate(@NonNull File file) {
        this.picasso.invalidate(file);
    }

    public void setIndicatorsEnabled(boolean enabled) {
        this.picasso.setIndicatorsEnabled(enabled);
    }

    public boolean getIndicatorsEnabled() {
        return this.picasso.areIndicatorsEnabled();
    }

    public void setLoggingEnabled(boolean enabled) {
        this.picasso.setLoggingEnabled(enabled);
    }

    public boolean isLoggingEnabled() {
        return this.picasso.isLoggingEnabled();
    }

    public void shutdown() {
        this.picasso.shutdown();
    }

    private static class TransformationConverter
    implements Transformation {
        private final TransformationCompat transformationCompat;

        TransformationConverter(TransformationCompat transformationCompat) {
            this.transformationCompat = transformationCompat;
        }

        public Bitmap transform(Bitmap source) {
            return this.transformationCompat.transform(source);
        }

        public String key() {
            return this.transformationCompat.key();
        }
    }

    private static class CallbackConverter
    implements Callback {
        private final CallbackCompat callbackCompat;

        private CallbackConverter(CallbackCompat callbackCompat) {
            this.callbackCompat = callbackCompat;
        }

        public void onSuccess() {
            if (this.callbackCompat != null) {
                this.callbackCompat.onSuccess();
            }
        }

        public void onError() {
            if (this.callbackCompat != null) {
                this.callbackCompat.onError();
            }
        }
    }

    private static class TargetConverter
    implements Target {
        private final TargetCompat targetCompat;

        private TargetConverter(TargetCompat targetCompat) {
            this.targetCompat = targetCompat;
        }

        public void onBitmapLoaded(Bitmap bitmap, Picasso.LoadedFrom from) {
            PicassoCompat.LoadedFrom source;
            switch (from) {
                case DISK: {
                    source = PicassoCompat.LoadedFrom.DISK;
                    break;
                }
                case MEMORY: {
                    source = PicassoCompat.LoadedFrom.MEMORY;
                    break;
                }
                case NETWORK: {
                    source = PicassoCompat.LoadedFrom.NETWORK;
                    break;
                }
                default: {
                    source = null;
                }
            }
            if (this.targetCompat != null) {
                this.targetCompat.onBitmapLoaded(bitmap, source);
            }
        }

        public void onBitmapFailed(Drawable errorDrawable) {
            if (this.targetCompat != null) {
                this.targetCompat.onBitmapFailed(errorDrawable);
            }
        }

        public void onPrepareLoad(Drawable placeHolderDrawable) {
            if (this.targetCompat != null) {
                this.targetCompat.onPrepareLoad(placeHolderDrawable);
            }
        }
    }

    class RequestCreatorCompat252
    implements RequestCreatorCompat {
        private final RequestCreator requestCreator;

        RequestCreatorCompat252(Picasso picasso, Uri uri) {
            this.requestCreator = picasso.load(uri);
        }

        RequestCreatorCompat252(Picasso picasso, String path) {
            this.requestCreator = picasso.load(path);
        }

        RequestCreatorCompat252(Picasso picasso, File file) {
            this.requestCreator = picasso.load(file);
        }

        RequestCreatorCompat252(Picasso picasso, int resourceId) {
            this.requestCreator = picasso.load(resourceId);
        }

        public RequestCreatorCompat noPlaceholder() {
            this.requestCreator.noPlaceholder();
            return this;
        }

        public RequestCreatorCompat placeholder(int placeholderResId) {
            this.requestCreator.placeholder(placeholderResId);
            return this;
        }

        public RequestCreatorCompat placeholder(Drawable placeholderDrawable) {
            this.requestCreator.placeholder(placeholderDrawable);
            return this;
        }

        public RequestCreatorCompat error(int errorResId) {
            this.requestCreator.error(errorResId);
            return this;
        }

        public RequestCreatorCompat error(Drawable errorDrawable) {
            this.requestCreator.error(errorDrawable);
            return this;
        }

        public RequestCreatorCompat tag(Object tag) {
            this.requestCreator.tag(tag);
            return null;
        }

        public RequestCreatorCompat fit() {
            this.requestCreator.fit();
            return this;
        }

        public RequestCreatorCompat resizeDimen(int targetWidthResId, int targetHeightResId) {
            this.requestCreator.resizeDimen(targetWidthResId, targetHeightResId);
            return this;
        }

        public RequestCreatorCompat resize(int targetWidth, int targetHeight) {
            this.requestCreator.resize(targetWidth, targetHeight);
            return this;
        }

        public RequestCreatorCompat centerCrop() {
            this.requestCreator.centerCrop();
            return this;
        }

        public RequestCreatorCompat centerInside() {
            this.requestCreator.centerInside();
            return this;
        }

        public RequestCreatorCompat onlyScaleDown() {
            this.requestCreator.onlyScaleDown();
            return this;
        }

        public RequestCreatorCompat rotate(float degrees) {
            this.requestCreator.rotate(degrees);
            return this;
        }

        public RequestCreatorCompat rotate(float degrees, float pivotX, float pivotY) {
            this.requestCreator.rotate(degrees, pivotX, pivotY);
            return this;
        }

        public RequestCreatorCompat config(Bitmap.Config config) {
            this.requestCreator.config(config);
            return this;
        }

        public RequestCreatorCompat stableKey(String stableKey) {
            this.requestCreator.stableKey(stableKey);
            return this;
        }

        public RequestCreatorCompat priority(PicassoCompat.Priority priority) {
            Picasso.Priority picassoPriority;
            switch (priority) {
                case LOW: {
                    picassoPriority = Picasso.Priority.LOW;
                    break;
                }
                case HIGH: {
                    picassoPriority = Picasso.Priority.HIGH;
                    break;
                }
                case NORMAL: {
                    picassoPriority = Picasso.Priority.NORMAL;
                    break;
                }
                default: {
                    picassoPriority = null;
                }
            }
            this.requestCreator.priority(picassoPriority);
            return this;
        }

        public RequestCreatorCompat transform(TransformationCompat transformation) {
            this.requestCreator.transform((Transformation)new TransformationConverter(transformation));
            return this;
        }

        public RequestCreatorCompat transform(List<? extends TransformationCompat> transformations) {
            ArrayList<TransformationConverter> picassoTransformations = new ArrayList<TransformationConverter>(transformations.size());
            for (TransformationCompat transformationCompat : transformations) {
                picassoTransformations.add(new TransformationConverter(transformationCompat));
            }
            this.requestCreator.transform(picassoTransformations);
            return this;
        }

        public RequestCreatorCompat noFade() {
            this.requestCreator.noFade();
            return this;
        }

        public Bitmap get() throws IOException {
            return this.requestCreator.get();
        }

        public void fetch() {
            this.requestCreator.fetch();
        }

        public void fetch(CallbackCompat callback) {
            this.requestCreator.fetch((Callback)new CallbackConverter(callback));
        }

        public void into(TargetCompat target) {
            if (PicassoCompat252.this.targetMap.containsKey(target)) {
                this.requestCreator.into((Target)PicassoCompat252.this.targetMap.get(target));
            } else {
                TargetConverter targetConverter = new TargetConverter(target);
                PicassoCompat252.this.targetMap.put(target, targetConverter);
                this.requestCreator.into((Target)targetConverter);
            }
        }

        public void into(RemoteViews remoteViews, int viewId, int notificationId, Notification notification) {
            this.requestCreator.into(remoteViews, viewId, notificationId, notification);
        }

        public void into(RemoteViews remoteViews, int viewId, int[] appWidgetIds) {
            this.requestCreator.into(remoteViews, viewId, appWidgetIds);
        }

        public void into(ImageView target) {
            this.requestCreator.into(target);
        }

        public void into(ImageView target, CallbackCompat callback) {
            this.requestCreator.into(target, (Callback)new CallbackConverter(callback));
        }
    }

    static class Builder
    implements PicassoCompat.Builder {
        private final Picasso.Builder builder;

        Builder(Context context) {
            this.builder = new Picasso.Builder(context);
        }

        public PicassoCompat.Builder defaultBitmapConfig(@NonNull Bitmap.Config bitmapConfig) {
            this.builder.defaultBitmapConfig(bitmapConfig);
            return this;
        }

        public PicassoCompat.Builder client(@NonNull OkHttpClient client) {
            this.builder.downloader((Downloader)new OkHttp3Downloader(client));
            return this;
        }

        public PicassoCompat.Builder callFactory(@NonNull Call.Factory factory) {
            this.builder.downloader((Downloader)new OkHttp3Downloader(factory));
            return this;
        }

        public PicassoCompat.Builder executor(@NonNull ExecutorService executorService) {
            this.builder.executor(executorService);
            return this;
        }

        public PicassoCompat.Builder listener(final @NonNull PicassoCompat.Listener listener) {
            this.builder.listener(new Picasso.Listener(){

                public void onImageLoadFailed(Picasso picasso, Uri uri, Exception exception) {
                    listener.onImageLoadFailed(uri, exception);
                }
            });
            return this;
        }

        public PicassoCompat.Builder indicatorsEnabled(boolean enabled) {
            this.builder.indicatorsEnabled(enabled);
            return this;
        }

        public PicassoCompat.Builder loggingEnabled(boolean enabled) {
            this.builder.loggingEnabled(enabled);
            return this;
        }

        public PicassoCompat build() {
            return new PicassoCompat252(this.builder.build());
        }
    }
}

