/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.utils;

import java.util.Map;
import java.util.TreeMap;
import java.util.stream.IntStream;

public final class DebugUtils {
    private static final char INDENTATION_CHARACTER = ' ';
    private static final int INDENTATION_SIZE = 2;

    private DebugUtils() {
        throw new UnsupportedOperationException();
    }

    public static String prettyToString(Object object) {
        return DebugUtils.prettyToString(object, 2);
    }

    public static String prettyToString(Object object, int indentation) {
        String string = object.toString();
        TreeMap<Integer, Integer> newLines = new TreeMap<Integer, Integer>();
        int currentLevel = 0;
        boolean inStringLiteral = false;
        for (int i = 0; i < string.length(); ++i) {
            char currentChar = string.charAt(i);
            if (currentChar == ',' && !inStringLiteral) {
                newLines.put(i, currentLevel);
            }
            if (currentChar == '{' && !inStringLiteral) {
                ++currentLevel;
            }
            if (currentChar == '}' && !inStringLiteral) {
                --currentLevel;
            }
            if (currentChar != '\'') continue;
            inStringLiteral = !inStringLiteral;
        }
        StringBuilder builder = new StringBuilder(string);
        int modifiedLength = 0;
        for (Map.Entry entry : newLines.entrySet()) {
            String intend = IntStream.range(0, (Integer)entry.getValue() * indentation).mapToObj(c -> Character.valueOf(' ')).collect(() -> new StringBuilder("\n"), StringBuilder::append, StringBuilder::append).toString();
            builder.insert(modifiedLength + (Integer)entry.getKey() + 1, intend);
            modifiedLength += intend.length();
        }
        return builder.toString();
    }
}

