/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model.rest;

import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeIdentifier;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeRepresentationVisitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class TypeRepresentation {
    private final TypeIdentifier identifier;

    private TypeRepresentation(TypeIdentifier identifier) {
        this.identifier = identifier;
    }

    public abstract void accept(TypeRepresentationVisitor var1);

    public TypeIdentifier getIdentifier() {
        return this.identifier;
    }

    public abstract TypeIdentifier getComponentType();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeRepresentation that = (TypeRepresentation)o;
        return this.identifier.equals(that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public static TypeRepresentation ofConcrete(TypeIdentifier identifier) {
        return new ConcreteTypeRepresentation(identifier, Collections.emptyMap());
    }

    public static TypeRepresentation ofConcrete(TypeIdentifier identifier, Map<String, TypeIdentifier> properties) {
        return new ConcreteTypeRepresentation(identifier, properties);
    }

    public static TypeRepresentation ofCollection(TypeIdentifier identifier, TypeRepresentation typeRepresentation) {
        return new CollectionTypeRepresentation(identifier, typeRepresentation);
    }

    public static TypeRepresentation ofEnum(TypeIdentifier identifier, String ... enumValues) {
        return new EnumTypeRepresentation(identifier, new HashSet<String>(Arrays.asList(enumValues)));
    }

    public static class EnumTypeRepresentation
    extends TypeRepresentation {
        private final Set<String> enumValues;

        private EnumTypeRepresentation(TypeIdentifier identifier, Set<String> enumValues) {
            super(identifier);
            this.enumValues = enumValues;
        }

        public Set<String> getEnumValues() {
            return this.enumValues;
        }

        @Override
        public void accept(TypeRepresentationVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public TypeIdentifier getComponentType() {
            return this.getIdentifier();
        }

        public String toString() {
            return "EnumTypeRepresentation{enumValues=" + this.enumValues + '}';
        }
    }

    public static class CollectionTypeRepresentation
    extends TypeRepresentation {
        private final TypeRepresentation representation;

        private CollectionTypeRepresentation(TypeIdentifier identifier, TypeRepresentation representation) {
            super(identifier);
            this.representation = representation;
        }

        public TypeRepresentation getRepresentation() {
            return this.representation;
        }

        @Override
        public TypeIdentifier getComponentType() {
            return this.representation.getIdentifier();
        }

        @Override
        public void accept(TypeRepresentationVisitor visitor) {
            visitor.visit(this);
            this.representation.accept(visitor);
        }

        public boolean contentEquals(TypeRepresentation representation) {
            boolean otherStaticType;
            boolean thisStaticType = !this.representation.getIdentifier().getType().equals("Ljavax/json/Json;");
            boolean bl = otherStaticType = !representation.getIdentifier().getType().equals("Ljavax/json/Json;");
            if (thisStaticType ^ otherStaticType) {
                return false;
            }
            if (thisStaticType) {
                return this.representation.getIdentifier().equals(representation.getIdentifier());
            }
            boolean thisCollection = this.representation instanceof CollectionTypeRepresentation;
            boolean thatCollection = representation instanceof CollectionTypeRepresentation;
            if (thisCollection ^ thatCollection) {
                return false;
            }
            if (thisCollection) {
                return ((CollectionTypeRepresentation)this.representation).contentEquals(((CollectionTypeRepresentation)representation).getRepresentation());
            }
            return ((ConcreteTypeRepresentation)this.representation).contentEquals(((ConcreteTypeRepresentation)representation).getProperties());
        }

        public String toString() {
            return "CollectionTypeRepresentation{identifier=" + this.getIdentifier() + ",representation=" + this.representation + '}';
        }
    }

    public static class ConcreteTypeRepresentation
    extends TypeRepresentation {
        private final Map<String, TypeIdentifier> properties;

        private ConcreteTypeRepresentation(TypeIdentifier identifier, Map<String, TypeIdentifier> properties) {
            super(identifier);
            this.properties = properties;
        }

        public Map<String, TypeIdentifier> getProperties() {
            return this.properties;
        }

        @Override
        public TypeIdentifier getComponentType() {
            return this.getIdentifier();
        }

        @Override
        public void accept(TypeRepresentationVisitor visitor) {
            visitor.visit(this);
        }

        public boolean contentEquals(Map<String, TypeIdentifier> properties) {
            return this.properties.equals(properties);
        }

        public String toString() {
            return "ConcreteTypeRepresentation{identifier=" + this.getIdentifier() + ",properties=" + this.properties + '}';
        }
    }
}

