/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model.rest;

import com.sebastian_daschner.jaxrs_analyzer.model.rest.HttpMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.MethodParameter;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Response;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeIdentifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ResourceMethod {
    private final Set<String> requestMediaTypes = new HashSet<String>();
    private final Set<String> responseMediaTypes = new HashSet<String>();
    private final Map<Integer, Response> responses = new HashMap<Integer, Response>();
    private final Set<MethodParameter> methodParameters = new HashSet<MethodParameter>();
    private final String description;
    private final HttpMethod method;
    private TypeIdentifier requestBody;
    private String requestBodyDescription;
    private boolean deprecated;

    public ResourceMethod(HttpMethod method, String description) {
        Objects.requireNonNull(method);
        this.method = method;
        this.description = description;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public Set<MethodParameter> getMethodParameters() {
        return this.methodParameters;
    }

    public TypeIdentifier getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(TypeIdentifier requestBody) {
        this.requestBody = requestBody;
    }

    public Set<String> getRequestMediaTypes() {
        return this.requestMediaTypes;
    }

    public Set<String> getResponseMediaTypes() {
        return this.responseMediaTypes;
    }

    public Map<Integer, Response> getResponses() {
        return this.responses;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRequestBodyDescription() {
        return this.requestBodyDescription;
    }

    public void setRequestBodyDescription(String requestBodyDescription) {
        this.requestBodyDescription = requestBodyDescription;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceMethod that = (ResourceMethod)o;
        if (!this.requestMediaTypes.equals(that.requestMediaTypes)) {
            return false;
        }
        if (!this.responseMediaTypes.equals(that.responseMediaTypes)) {
            return false;
        }
        if (!this.responses.equals(that.responses)) {
            return false;
        }
        if (!this.methodParameters.equals(that.methodParameters)) {
            return false;
        }
        if (this.method != that.method) {
            return false;
        }
        if (this.deprecated != that.deprecated) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.requestBodyDescription != null ? !this.requestBodyDescription.equals(that.requestBodyDescription) : that.requestBodyDescription != null) {
            return false;
        }
        return this.requestBody != null ? this.requestBody.equals(that.requestBody) : that.requestBody == null;
    }

    public int hashCode() {
        int result = this.requestMediaTypes.hashCode();
        result = 31 * result + this.responseMediaTypes.hashCode();
        result = 31 * result + this.responses.hashCode();
        result = 31 * result + this.methodParameters.hashCode();
        result = 31 * result + this.method.hashCode();
        result = 31 * result + (this.deprecated ? 1231 : 1237);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.requestBodyDescription != null ? this.requestBodyDescription.hashCode() : 0);
        result = 31 * result + (this.requestBody != null ? this.requestBody.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ResourceMethod{method=" + (Object)((Object)this.method) + ", requestMediaTypes=" + this.requestMediaTypes + ", responseMediaTypes=" + this.responseMediaTypes + ", responses=" + this.responses + ", methodParameters=" + this.methodParameters + ", description=" + this.description + ", requestBodyDescription=" + this.requestBodyDescription + ", requestBody=" + this.requestBody + '}';
    }
}

