/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model.instructions;

import com.sebastian_daschner.jaxrs_analyzer.model.instructions.Instruction;
import org.objectweb.asm.Label;

public class PushInstruction
extends Instruction {
    private final Object value;
    private final String valueType;

    public PushInstruction(Object value, String valueType, Label label) {
        super(label);
        this.value = value;
        this.valueType = valueType;
    }

    public Object getValue() {
        return this.value;
    }

    public String getValueType() {
        return this.valueType;
    }

    @Override
    public Instruction.InstructionType getType() {
        return Instruction.InstructionType.PUSH;
    }

    @Override
    public int getStackSizeDifference() {
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PushInstruction that = (PushInstruction)o;
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return this.valueType != null ? this.valueType.equals(that.valueType) : that.valueType == null;
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.valueType != null ? this.valueType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "PushInstruction{value=" + this.value + ", valueType='" + this.valueType + '\'' + '}';
    }
}

