/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model.elements;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Element {
    private final Set<Object> possibleValues;
    private final Set<String> types;

    public Element() {
        this(Collections.singleton("Ljava/lang/Object;"), new Object[0]);
    }

    public Element(String type, Object ... values) {
        this(Collections.singleton(type), values);
    }

    public Element(Set<String> types, Object ... values) {
        Objects.requireNonNull(types);
        this.types = new HashSet<String>(types);
        this.possibleValues = new HashSet<Object>();
        if (values == null) {
            this.possibleValues.add(null);
        } else {
            Collections.addAll(this.possibleValues, values);
        }
    }

    public Element merge(Element element) {
        this.types.addAll(element.types);
        this.possibleValues.addAll(element.possibleValues);
        return this;
    }

    public Set<Object> getPossibleValues() {
        return this.possibleValues;
    }

    public Set<String> getTypes() {
        return this.types;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Element element = (Element)o;
        if (!this.possibleValues.equals(element.possibleValues)) {
            return false;
        }
        return this.types.equals(element.types);
    }

    public int hashCode() {
        int result = this.possibleValues.hashCode();
        result = 31 * result + this.types.hashCode();
        return result;
    }

    public String toString() {
        return "Element{possibleValues=" + this.possibleValues + ", types='" + this.types + '\'' + '}';
    }
}

