/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.analysis.classes.ContextClassReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.util.TraceSignatureVisitor;

public final class JavaUtils {
    public static final String INITIALIZER_NAME = "<init>";

    private JavaUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean isInitializerName(String name) {
        return INITIALIZER_NAME.equals(name);
    }

    public static <A extends Annotation> A getAnnotation(AnnotatedElement annotatedElement, Class<A> annotationClass) {
        Optional<Annotation> annotation = Stream.of(annotatedElement.getAnnotations()).filter(a -> a.annotationType().getName().equals(annotationClass.getName())).findAny();
        return (A)((Annotation)annotation.orElse(null));
    }

    public static boolean isAnnotationPresent(AnnotatedElement annotatedElement, Class<?> annotationClass) {
        return Stream.of(annotatedElement.getAnnotations()).map(Annotation::annotationType).map(Class::getName).anyMatch(n -> n.equals(annotationClass.getName()));
    }

    public static String determineMostSpecificType(String ... types) {
        switch (types.length) {
            case 0: {
                throw new IllegalArgumentException("At least one type has to be provided");
            }
            case 1: {
                return types[0];
            }
            case 2: {
                return JavaUtils.determineMostSpecific(types[0], types[1]);
            }
        }
        String currentMostSpecific = JavaUtils.determineMostSpecific(types[0], types[1]);
        for (int i = 2; i < types.length; ++i) {
            currentMostSpecific = JavaUtils.determineMostSpecific(currentMostSpecific, types[i]);
        }
        return currentMostSpecific;
    }

    private static String determineMostSpecific(String firstType, String secondType) {
        boolean secondTypeArray;
        boolean secondTypeParameterized;
        if ("Ljava/lang/Object;".equals(secondType) || firstType.equals(secondType)) {
            return firstType;
        }
        if ("Ljava/lang/Object;".equals(firstType)) {
            return secondType;
        }
        List<String> firstTypeParameters = JavaUtils.getTypeParameters(firstType);
        List<String> secondTypeParameters = JavaUtils.getTypeParameters(secondType);
        boolean firstTypeParameterized = !firstTypeParameters.isEmpty();
        boolean bl = secondTypeParameterized = !secondTypeParameters.isEmpty();
        if (firstTypeParameterized || secondTypeParameterized) {
            if (firstTypeParameterized && !secondTypeParameterized) {
                return firstType;
            }
            if (!firstTypeParameterized) {
                return secondType;
            }
            if (firstTypeParameters.size() != secondTypeParameters.size()) {
                return firstType;
            }
            for (int i = 0; i < firstTypeParameters.size(); ++i) {
                String secondInner;
                String firstInner = firstTypeParameters.get(i);
                if (firstInner.equals(secondInner = secondTypeParameters.get(i))) continue;
                if (firstInner == JavaUtils.determineMostSpecific(firstInner, secondInner)) {
                    return firstType;
                }
                return secondType;
            }
        }
        boolean firstTypeArray = firstType.charAt(0) == '[';
        boolean bl2 = secondTypeArray = secondType.charAt(0) == '[';
        if (firstTypeArray || secondTypeArray) {
            if (firstTypeArray && !secondTypeArray) {
                return firstType;
            }
            if (!firstTypeArray) {
                return secondType;
            }
        }
        if (JavaUtils.isAssignableTo(firstType, secondType)) {
            return firstType;
        }
        if (JavaUtils.isAssignableTo(secondType, firstType)) {
            return secondType;
        }
        return firstType;
    }

    public static String determineLeastSpecificType(String ... types) {
        switch (types.length) {
            case 0: {
                throw new IllegalArgumentException("At least one type has to be provided");
            }
            case 1: {
                return types[0];
            }
            case 2: {
                return JavaUtils.determineLeastSpecific(types[0], types[1]);
            }
        }
        String currentLeastSpecific = JavaUtils.determineLeastSpecific(types[0], types[1]);
        for (int i = 2; i < types.length; ++i) {
            currentLeastSpecific = JavaUtils.determineLeastSpecific(currentLeastSpecific, types[i]);
        }
        return currentLeastSpecific;
    }

    private static String determineLeastSpecific(String firstType, String secondType) {
        String mostSpecificType = JavaUtils.determineMostSpecificType(firstType, secondType);
        if (mostSpecificType == firstType) {
            return secondType;
        }
        return firstType;
    }

    public static boolean isAssignableTo(String leftType, String rightType) {
        if (leftType.equals(rightType)) {
            return true;
        }
        boolean firstTypeArray = leftType.charAt(0) == '[';
        if (firstTypeArray ^ rightType.charAt(0) == '[') {
            return false;
        }
        Class<?> leftClass = JavaUtils.loadClassFromType(leftType);
        Class<?> rightClass = JavaUtils.loadClassFromType(rightType);
        if (leftClass == null || rightClass == null) {
            return false;
        }
        boolean bothTypesParameterized = JavaUtils.hasTypeParameters(leftType) && JavaUtils.hasTypeParameters(rightType);
        return rightClass.isAssignableFrom(leftClass) && (firstTypeArray || !bothTypesParameterized || JavaUtils.getTypeParameters(leftType).equals(JavaUtils.getTypeParameters(rightType)));
    }

    private static boolean hasTypeParameters(String type) {
        return type.indexOf(60) >= 0;
    }

    public static String toClassName(String type) {
        switch (type.charAt(0)) {
            case 'V': {
                return "void";
            }
            case 'Z': {
                return "boolean";
            }
            case 'C': {
                return "char";
            }
            case 'B': {
                return "byte";
            }
            case 'S': {
                return "short";
            }
            case 'I': {
                return "int";
            }
            case 'F': {
                return "float";
            }
            case 'J': {
                return "long";
            }
            case 'D': {
                return "double";
            }
            case 'L': {
                int typeParamStart = type.indexOf(60);
                int endIndex = typeParamStart >= 0 ? typeParamStart : type.indexOf(59);
                return type.substring(1, endIndex);
            }
            case '+': 
            case '-': 
            case '[': {
                return JavaUtils.toClassName(type.substring(1));
            }
            case 'T': {
                return "java/lang/Object";
            }
        }
        throw new IllegalArgumentException("Not a type signature: " + type);
    }

    public static String toType(String className) {
        return 'L' + className + ';';
    }

    public static String toReadableType(String type) {
        SignatureReader reader = new SignatureReader(type);
        TraceSignatureVisitor visitor = new TraceSignatureVisitor(0);
        reader.acceptType(visitor);
        return visitor.getDeclaration();
    }

    public static String getType(Object value) {
        return Type.getDescriptor(value.getClass());
    }

    public static List<String> getTypeParameters(String type) {
        if (type.charAt(0) != 'L') {
            return Collections.emptyList();
        }
        int lastStart = type.indexOf(60) + 1;
        ArrayList<String> parameters = new ArrayList<String>();
        if (lastStart > 0) {
            int depth = 0;
            for (int i = lastStart; i < type.length() - 2; ++i) {
                char c = type.charAt(i);
                if (c == '<') {
                    ++depth;
                    continue;
                }
                if (c == '>') {
                    --depth;
                    continue;
                }
                if (c != ';' || depth != 0) continue;
                parameters.add(type.substring(lastStart, i + 1));
                lastStart = i + 1;
            }
        }
        return parameters;
    }

    public static String getReturnType(String methodSignature) {
        return JavaUtils.getReturnType(methodSignature, null);
    }

    public static String getReturnType(String methodSignature, String containedType) {
        String type = methodSignature.substring(methodSignature.lastIndexOf(41) + 1);
        return JavaUtils.resolvePotentialTypeVariables(type, containedType);
    }

    private static Map<String, String> getTypeVariables(String type) {
        if (type == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> variables = new HashMap<String, String>();
        List<String> actualTypeParameters = JavaUtils.getTypeParameters(type);
        Class<?> loadedClass = JavaUtils.loadClassFromType(type);
        if (loadedClass == null) {
            LogProvider.debug("could not load class for type " + type);
            return Collections.emptyMap();
        }
        TypeVariable<Class<?>>[] typeParameters = loadedClass.getTypeParameters();
        for (int i = 0; i < actualTypeParameters.size(); ++i) {
            variables.put(typeParameters[i].getName(), actualTypeParameters.get(i));
        }
        return variables;
    }

    public static Class<?> loadClassFromName(String className) {
        switch (className) {
            case "void": {
                return Integer.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
        }
        ClassLoader classLoader = ContextClassReader.getClassLoader();
        try {
            return classLoader.loadClass(className.replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            LogProvider.error("Could not load class " + className);
            LogProvider.debug(e);
            return null;
        }
    }

    public static Class<?> loadClassFromType(String type) {
        return JavaUtils.loadClassFromName(JavaUtils.toClassName(type));
    }

    public static Method findMethod(String className, String methodName, String signature) {
        Class<?> loadedClass = JavaUtils.loadClassFromName(className);
        if (loadedClass == null) {
            return null;
        }
        return JavaUtils.findMethod(loadedClass, methodName, signature);
    }

    public static Method findMethod(Class<?> loadedClass, String methodName, String signature) {
        List<String> parameters = JavaUtils.getParameters(signature);
        return Stream.of(loadedClass.getDeclaredMethods()).filter(m -> m.getName().equals(methodName) && m.getParameterCount() == parameters.size() && Objects.equals(JavaUtils.getParameters(JavaUtils.getMethodSignature(m)), parameters)).findAny().orElse(null);
    }

    public static String getMethodSignature(String returnType, String ... parameterTypes) {
        String parameters = Stream.of(parameterTypes).collect(Collectors.joining());
        return '(' + parameters + ')' + returnType;
    }

    public static String getMethodSignature(Method method) {
        try {
            Field signatureField = method.getClass().getDeclaredField("signature");
            signatureField.setAccessible(true);
            String signature = (String)signatureField.get(method);
            if (signature != null) {
                return signature;
            }
            return Type.getMethodDescriptor(method);
        }
        catch (ReflectiveOperationException e) {
            LogProvider.error("Could not access method " + method);
            LogProvider.debug(e);
            return null;
        }
    }

    public static String getFieldDescriptor(Field field, String containedType) {
        try {
            Field signatureField = field.getClass().getDeclaredField("signature");
            signatureField.setAccessible(true);
            String signature = (String)signatureField.get(field);
            if (signature != null) {
                return JavaUtils.resolvePotentialTypeVariables(signature, containedType);
            }
            return Type.getDescriptor(field.getType());
        }
        catch (ReflectiveOperationException e) {
            LogProvider.error("Could not access field " + field);
            LogProvider.debug(e);
            return null;
        }
    }

    private static String resolvePotentialTypeVariables(String signature, String containedType) {
        if (signature.charAt(0) == 'T' || signature.contains("<T") || signature.contains(";T") || signature.contains(")T")) {
            Map<String, String> typeVariables = JavaUtils.getTypeVariables(containedType);
            StringBuilder builder = new StringBuilder(signature);
            boolean startType = true;
            for (int i = 0; i < builder.length(); ++i) {
                if (startType && builder.charAt(i) == 'T') {
                    int end = builder.indexOf(";", i);
                    String identifier = builder.substring(i + 1, end);
                    String resolvedVariableType = typeVariables.getOrDefault(identifier, "Ljava/lang/Object;");
                    builder.replace(i, end + 1, resolvedVariableType);
                    i = end;
                    continue;
                }
                startType = builder.charAt(i) == '<' || builder.charAt(i) == ';';
            }
            return builder.toString();
        }
        return signature;
    }

    public static List<String> getParameters(String methodDesc) {
        if (methodDesc == null) {
            return Collections.emptyList();
        }
        char[] buffer = methodDesc.toCharArray();
        ArrayList<String> args = new ArrayList<String>();
        int offset = methodDesc.indexOf(40) + 1;
        while (buffer[offset] != ')') {
            String type = JavaUtils.getNextType(buffer, offset);
            args.add(type);
            offset += type.length();
        }
        ListIterator<String> iterator = args.listIterator();
        while (iterator.hasNext()) {
            String arg = (String)iterator.next();
            if (arg.charAt(0) != 'T') continue;
            iterator.set("Ljava/lang/Object;");
        }
        return args;
    }

    private static String[] resolveMethodSignature(String methodDesc) {
        return null;
    }

    private static Map<String, String> resolveTypeParameters(String methodDesc) {
        return null;
    }

    private static String getNextType(char[] buf, int off) {
        switch (buf[off]) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return String.valueOf(buf[off]);
            }
            case '[': {
                int len = 1;
                while (buf[off + len] == '[') {
                    ++len;
                }
                return JavaUtils.getNextType(buf, off, len);
            }
            case 'L': 
            case 'T': {
                return JavaUtils.getNextType(buf, off, 0);
            }
        }
        throw new IllegalArgumentException("Illegal signature provided: " + new String(buf));
    }

    private static String getNextType(char[] buf, int off, int len) {
        int depth = 0;
        if (buf[off + len] == 'L' || buf[off + len] == 'T') {
            while (buf[off + len] != ';' || depth != 0) {
                if (buf[off + len] == '<') {
                    ++depth;
                } else if (buf[off + len] == '>') {
                    --depth;
                }
                ++len;
            }
        }
        return new String(buf, off, len + 1);
    }
}

