/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.backend.swagger;

import com.sebastian_daschner.jaxrs_analyzer.backend.ComparatorUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.Types;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeIdentifier;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeRepresentation;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeRepresentationVisitor;
import com.sebastian_daschner.jaxrs_analyzer.utils.Pair;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

class SchemaBuilder {
    private final Map<String, Pair<String, JsonObject>> jsonDefinitions = new HashMap<String, Pair<String, JsonObject>>();
    private final Map<TypeIdentifier, TypeRepresentation> typeRepresentations;

    SchemaBuilder(Map<TypeIdentifier, TypeRepresentation> typeRepresentations) {
        this.typeRepresentations = typeRepresentations;
    }

    JsonObjectBuilder build(TypeIdentifier identifier) {
        SwaggerType type = SchemaBuilder.toSwaggerType(identifier.getType());
        switch (type) {
            case BOOLEAN: 
            case INTEGER: 
            case NUMBER: 
            case NULL: 
            case STRING: {
                JsonObjectBuilder builder = Json.createObjectBuilder();
                this.addPrimitive(builder, type);
                return builder;
            }
        }
        final JsonObjectBuilder builder = Json.createObjectBuilder();
        TypeRepresentationVisitor visitor = new TypeRepresentationVisitor(){
            private boolean inCollection = false;

            @Override
            public void visit(TypeRepresentation.ConcreteTypeRepresentation representation) {
                JsonObjectBuilder nestedBuilder = this.inCollection ? Json.createObjectBuilder() : builder;
                SchemaBuilder.this.add(nestedBuilder, representation);
                if (this.inCollection) {
                    builder.add("items", nestedBuilder.build());
                }
            }

            @Override
            public void visit(TypeRepresentation.CollectionTypeRepresentation representation) {
                builder.add("type", "array");
                this.inCollection = true;
            }

            @Override
            public void visit(TypeRepresentation.EnumTypeRepresentation representation) {
                builder.add("type", "string");
                if (!representation.getEnumValues().isEmpty()) {
                    JsonArrayBuilder array = representation.getEnumValues().stream().sorted().collect(Json::createArrayBuilder, JsonArrayBuilder::add, JsonArrayBuilder::add);
                    builder.add("enum", array);
                }
            }
        };
        TypeRepresentation representation = this.typeRepresentations.get(identifier);
        if (representation == null) {
            builder.add("type", "object");
        } else {
            representation.accept(visitor);
        }
        return builder;
    }

    JsonObject getDefinitions() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.jsonDefinitions.entrySet().stream().sorted(ComparatorUtils.mapKeyComparator()).forEach(e -> builder.add((String)e.getKey(), (JsonValue)((Pair)e.getValue()).getRight()));
        return builder.build();
    }

    private void add(JsonObjectBuilder builder, TypeRepresentation.ConcreteTypeRepresentation representation) {
        SwaggerType type = SchemaBuilder.toSwaggerType(representation.getIdentifier().getType());
        switch (type) {
            case BOOLEAN: 
            case INTEGER: 
            case NUMBER: 
            case NULL: 
            case STRING: {
                this.addPrimitive(builder, type);
                return;
            }
        }
        this.addObject(builder, representation.getIdentifier(), representation.getProperties());
    }

    private void addObject(JsonObjectBuilder builder, TypeIdentifier identifier, Map<String, TypeIdentifier> properties) {
        String definition = this.buildDefinition(identifier.getName());
        if (this.jsonDefinitions.containsKey(definition)) {
            builder.add("$ref", "#/definitions/" + definition);
            return;
        }
        this.jsonDefinitions.put(definition, Pair.of(identifier.getName(), Json.createObjectBuilder().build()));
        JsonObjectBuilder nestedBuilder = Json.createObjectBuilder();
        properties.entrySet().stream().sorted(ComparatorUtils.mapKeyComparator()).forEach(e -> nestedBuilder.add((String)e.getKey(), this.build((TypeIdentifier)e.getValue())));
        this.jsonDefinitions.put(definition, Pair.of(identifier.getName(), Json.createObjectBuilder().add("properties", nestedBuilder).build()));
        builder.add("$ref", "#/definitions/" + definition);
    }

    private void addPrimitive(JsonObjectBuilder builder, SwaggerType type) {
        builder.add("type", type.toString());
    }

    private String buildDefinition(String typeName) {
        String definition = typeName.startsWith("$") ? "JsonObject" : typeName.substring(typeName.lastIndexOf(47) + 1, typeName.length() - 1);
        Pair<String, JsonObject> containedEntry = this.jsonDefinitions.get(definition);
        if (containedEntry == null || containedEntry.getLeft() != null && containedEntry.getLeft().equals(typeName)) {
            return definition;
        }
        if (!definition.matches("_\\d+$")) {
            return definition + "_2";
        }
        int separatorIndex = definition.lastIndexOf(95);
        int index = Integer.parseInt(definition.substring(separatorIndex + 1));
        return definition.substring(0, separatorIndex + 1) + (index + 1);
    }

    private static SwaggerType toSwaggerType(String type) {
        if (Types.INTEGER_TYPES.contains(type)) {
            return SwaggerType.INTEGER;
        }
        if (Types.DOUBLE_TYPES.contains(type)) {
            return SwaggerType.NUMBER;
        }
        if ("Ljava/lang/Boolean;".equals(type) || "Z".equals(type)) {
            return SwaggerType.BOOLEAN;
        }
        if ("Ljava/lang/String;".equals(type)) {
            return SwaggerType.STRING;
        }
        return SwaggerType.OBJECT;
    }

    private static enum SwaggerType {
        ARRAY,
        BOOLEAN,
        INTEGER,
        NULL,
        NUMBER,
        OBJECT,
        STRING;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

