/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.results;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.sebastian_daschner.jaxrs_analyzer.analysis.results.ResponseTypeNormalizer;
import com.sebastian_daschner.jaxrs_analyzer.model.JavaUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.Types;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeIdentifier;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeRepresentation;
import com.sebastian_daschner.jaxrs_analyzer.utils.Pair;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.objectweb.asm.Type;

class JavaTypeAnalyzer {
    private static final String[] NAMES_TO_IGNORE = new String[]{"getClass"};
    private static Set<String> ignoredFieldNames = new HashSet<String>();
    private final Map<TypeIdentifier, TypeRepresentation> typeRepresentations;
    private final Set<String> analyzedTypes;

    JavaTypeAnalyzer(Map<TypeIdentifier, TypeRepresentation> typeRepresentations) {
        this.typeRepresentations = typeRepresentations;
        this.analyzedTypes = new HashSet<String>();
    }

    TypeIdentifier analyze(String rootType) {
        String type = ResponseTypeNormalizer.normalizeResponseWrapper(rootType);
        TypeIdentifier identifier = TypeIdentifier.ofType(type);
        if (!(this.analyzedTypes.contains(type) || !JavaUtils.isAssignableTo(type, "Ljava/util/Collection;") && JavaTypeAnalyzer.isJDKType(type))) {
            this.analyzedTypes.add(type);
            this.typeRepresentations.put(identifier, this.analyzeInternal(identifier, type));
        }
        return identifier;
    }

    private static boolean isJDKType(String type) {
        return Types.PRIMITIVE_TYPES.contains(type) || type.startsWith("Ljava/") || type.startsWith("Ljavax/");
    }

    private TypeRepresentation analyzeInternal(TypeIdentifier identifier, String type) {
        if (JavaUtils.isAssignableTo(type, "Ljava/util/Collection;")) {
            String containedType = ResponseTypeNormalizer.normalizeCollection(type);
            return TypeRepresentation.ofCollection(identifier, this.analyzeInternal(TypeIdentifier.ofType(containedType), containedType));
        }
        Class<?> loadedClass = JavaUtils.loadClassFromType(type);
        if (loadedClass != null && loadedClass.isEnum()) {
            return TypeRepresentation.ofEnum(identifier, (String[])Stream.of(loadedClass.getEnumConstants()).map(o -> (Enum)o).map(Enum::name).toArray(String[]::new));
        }
        return TypeRepresentation.ofConcrete(identifier, this.analyzeClass(type, loadedClass));
    }

    private Map<String, TypeIdentifier> analyzeClass(String type, Class<?> clazz) {
        if (clazz == null || JavaTypeAnalyzer.isJDKType(type)) {
            return Collections.emptyMap();
        }
        XmlAccessType value = this.getXmlAccessType(clazz);
        ignoredFieldNames.clear();
        List relevantFields = Stream.of(clazz.getDeclaredFields()).filter(f -> JavaTypeAnalyzer.isRelevant(f, value)).collect(Collectors.toList());
        List relevantGetters = Stream.of(clazz.getDeclaredMethods()).filter(m -> JavaTypeAnalyzer.isRelevant(m, value)).collect(Collectors.toList());
        HashMap<String, TypeIdentifier> properties = new HashMap<String, TypeIdentifier>();
        Stream<Class<?>> allSuperTypes = Stream.concat(Stream.of(clazz.getInterfaces()), Stream.of(clazz.getSuperclass()));
        allSuperTypes.filter(Objects::nonNull).map(Type::getDescriptor).map(t -> this.analyzeClass((String)t, JavaUtils.loadClassFromType(t))).forEach(properties::putAll);
        Stream.concat(relevantFields.stream().map(f -> JavaTypeAnalyzer.mapField(f, type)), relevantGetters.stream().map(g -> JavaTypeAnalyzer.mapGetter(g, type))).filter(Objects::nonNull).forEach(p -> {
            properties.put((String)p.getLeft(), TypeIdentifier.ofType((String)p.getRight()));
            this.analyze((String)p.getRight());
        });
        return properties;
    }

    private XmlAccessType getXmlAccessType(Class<?> clazz) {
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            if (!JavaUtils.isAnnotationPresent(current, XmlAccessorType.class)) continue;
            return JavaUtils.getAnnotation(current, XmlAccessorType.class).value();
        }
        return XmlAccessType.PUBLIC_MEMBER;
    }

    private static boolean isRelevant(Field field, XmlAccessType accessType) {
        if (field.isSynthetic()) {
            return false;
        }
        if (JavaTypeAnalyzer.hasIgnoreAnnotation(field) || JavaTypeAnalyzer.isTypeIgnored(field.getType())) {
            ignoredFieldNames.add(field.getName());
            return false;
        }
        if (JavaUtils.isAnnotationPresent(field, XmlElement.class)) {
            return true;
        }
        int modifiers = field.getModifiers();
        if (accessType == XmlAccessType.FIELD) {
            return !Modifier.isTransient(modifiers) && !Modifier.isStatic(modifiers) && !JavaUtils.isAnnotationPresent(field, XmlTransient.class);
        }
        if (accessType == XmlAccessType.PUBLIC_MEMBER) {
            return Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && !JavaUtils.isAnnotationPresent(field, XmlTransient.class);
        }
        return false;
    }

    private static <T extends AccessibleObject> boolean hasIgnoreAnnotation(T member) {
        return JavaUtils.isAnnotationPresent(member, JsonIgnore.class) || JavaTypeAnalyzer.isTypeIgnored(((Member)((Object)member)).getDeclaringClass());
    }

    private static boolean isTypeIgnored(Class<?> declaringClass) {
        return JavaUtils.isAnnotationPresent(declaringClass, JsonIgnoreType.class);
    }

    private static boolean isRelevant(Method method, XmlAccessType accessType) {
        if (method.isSynthetic() || !JavaTypeAnalyzer.isGetter(method)) {
            return false;
        }
        boolean propertyIgnored = ignoredFieldNames.contains(JavaTypeAnalyzer.extractPropertyName(method.getName()));
        if (propertyIgnored || JavaTypeAnalyzer.hasIgnoreAnnotation(method) || JavaTypeAnalyzer.isTypeIgnored(method.getReturnType())) {
            return false;
        }
        if (JavaUtils.isAnnotationPresent(method, XmlElement.class)) {
            return true;
        }
        if (accessType == XmlAccessType.PROPERTY) {
            return !JavaUtils.isAnnotationPresent(method, XmlTransient.class);
        }
        if (accessType == XmlAccessType.PUBLIC_MEMBER) {
            return Modifier.isPublic(method.getModifiers()) && !JavaUtils.isAnnotationPresent(method, XmlTransient.class);
        }
        return false;
    }

    private static String extractPropertyName(String name) {
        int size = name.startsWith("is") ? 2 : 3;
        char[] chars = name.substring(size).toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private static boolean isGetter(Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        String name = method.getName();
        if (Stream.of(NAMES_TO_IGNORE).anyMatch(n -> n.equals(name))) {
            return false;
        }
        if (name.startsWith("get") && name.length() > 3) {
            return method.getReturnType() != Void.TYPE;
        }
        return name.startsWith("is") && name.length() > 2 && method.getReturnType() == Boolean.TYPE;
    }

    private static Pair<String, String> mapField(Field field, String containedType) {
        String type = JavaUtils.getFieldDescriptor(field, containedType);
        if (type == null) {
            return null;
        }
        return Pair.of(field.getName(), type);
    }

    private static Pair<String, String> mapGetter(Method method, String containedType) {
        String returnType = JavaUtils.getReturnType(JavaUtils.getMethodSignature(method), containedType);
        if (returnType == null) {
            return null;
        }
        return Pair.of(JavaTypeAnalyzer.extractPropertyName(method.getName()), returnType);
    }
}

