/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.results;

import com.sebastian_daschner.jaxrs_analyzer.model.JavaUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.MethodParameter;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.ParameterType;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.Type;
import java.util.Optional;
import java.util.stream.Stream;

final class JavaDocParameterResolver {
    private static final String[] KNOWN_ANNOTATIONS = new String[]{"Ljavax/ws/rs/PathParam;", "Ljavax/ws/rs/QueryParam;", "Ljavax/ws/rs/HeaderParam;", "Ljavax/ws/rs/FormParam;", "Ljavax/ws/rs/CookieParam;", "Ljavax/ws/rs/MatrixParam;", "Ljavax/ws/rs/DefaultValue;", "Ljavax/ws/rs/container/Suspended;", "Ljavax/ws/rs/core/Context;"};

    private JavaDocParameterResolver() {
        throw new UnsupportedOperationException();
    }

    static Optional<ParamTag> findParameterDoc(MethodParameter parameter, MethodDoc methodDoc) {
        Optional<String> paramName = Stream.of(methodDoc.parameters()).filter(p -> JavaDocParameterResolver.hasAnnotation(parameter, p.annotations())).map(Parameter::name).findAny();
        if (!paramName.isPresent()) {
            return Optional.empty();
        }
        return Stream.of(methodDoc.paramTags()).filter(t -> t.parameterName().equals(paramName.get())).findAny();
    }

    static Optional<FieldDoc> findFieldDoc(MethodParameter parameter, ClassDoc classDoc) {
        if (classDoc == null) {
            return Optional.empty();
        }
        return Stream.of(classDoc.fields(false)).filter(f -> JavaDocParameterResolver.hasAnnotation(parameter, f.annotations())).findAny();
    }

    static Optional<ParamTag> findRequestBodyDoc(MethodDoc methodDoc) {
        Optional<String> paramName = Stream.of(methodDoc.parameters()).filter(p -> JavaDocParameterResolver.isRequestBody(p.annotations())).map(Parameter::name).findAny();
        return Stream.of(methodDoc.paramTags()).filter(t -> t.parameterName().equals(paramName.get())).findAny();
    }

    private static boolean hasAnnotation(MethodParameter parameter, AnnotationDesc ... annotations) {
        return Stream.of(annotations).filter(a -> JavaDocParameterResolver.annotationTypeMatches(a.annotationType().qualifiedTypeName(), parameter.getParameterType())).anyMatch(a -> JavaDocParameterResolver.annotationValueMatches(a.elementValues(), parameter.getName()));
    }

    private static boolean isRequestBody(AnnotationDesc ... annotations) {
        return Stream.of(annotations).map(AnnotationDesc::annotationType).map(Type::qualifiedTypeName).noneMatch(t -> Stream.of(KNOWN_ANNOTATIONS).anyMatch(a -> t.equals(JavaUtils.toReadableType(a))));
    }

    private static boolean annotationTypeMatches(String qualifiedTypeName, ParameterType parameterType) {
        return qualifiedTypeName.equals(JavaDocParameterResolver.getJavaType(parameterType));
    }

    private static boolean annotationValueMatches(AnnotationDesc.ElementValuePair[] elementValuePairs, String name) {
        return Stream.of(elementValuePairs).anyMatch(p -> "value".equals(p.element().name()) && name.equals(p.value().value()));
    }

    private static String getJavaType(ParameterType parameterType) {
        switch (parameterType) {
            case PATH: {
                return JavaUtils.toReadableType("Ljavax/ws/rs/PathParam;");
            }
            case QUERY: {
                return JavaUtils.toReadableType("Ljavax/ws/rs/QueryParam;");
            }
            case HEADER: {
                return JavaUtils.toReadableType("Ljavax/ws/rs/HeaderParam;");
            }
            case FORM: {
                return JavaUtils.toReadableType("Ljavax/ws/rs/FormParam;");
            }
            case MATRIX: {
                return JavaUtils.toReadableType("Ljavax/ws/rs/MatrixParam;");
            }
            case COOKIE: {
                return JavaUtils.toReadableType("Ljavax/ws/rs/CookieParam;");
            }
        }
        return null;
    }
}

