/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.javadoc;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.analysis.classes.ContextClassReader;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.MethodIdentifier;
import com.sebastian_daschner.jaxrs_analyzer.model.results.ClassResult;
import com.sebastian_daschner.jaxrs_analyzer.model.results.MethodResult;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JavaDocAnalyzer {
    private static final Map<MethodIdentifier, MethodDoc> METHOD_DOCS = new ConcurrentHashMap<MethodIdentifier, MethodDoc>();
    private static final Map<String, ClassDoc> CLASS_DOCS = new ConcurrentHashMap<String, ClassDoc>();

    public void analyze(Set<ClassResult> classResults, Set<String> packages, Set<Path> projectSourcePaths, Set<Path> classPaths) {
        try {
            this.invokeDoclet(packages, projectSourcePaths, classPaths);
            this.combineResults(classResults);
        }
        catch (Exception e) {
            LogProvider.error("could not analyze JavaDoc, reason: " + e.getMessage());
            LogProvider.debug(e);
        }
    }

    private void invokeDoclet(Set<String> packages, Set<Path> projectSourcePaths, Set<Path> classPaths) throws Exception {
        String docletName = "com.sebastian_daschner.jaxrs_analyzer.analysis.javadoc.JAXRSDoclet";
        Class<?> doclet = ContextClassReader.getClassLoader().loadClass("com.sebastian_daschner.jaxrs_analyzer.analysis.javadoc.JAXRSDoclet");
        String docletPath = Paths.get(doclet.getProtectionDomain().getCodeSource().getLocation().toURI()).toString();
        String encoding = System.getProperty("project.build.sourceEncoding", Charset.defaultCharset().name());
        String[] args = (String[])Stream.concat(Stream.of("-sourcepath", this.joinPaths(projectSourcePaths), "-classpath", this.joinPaths(classPaths), "-quiet", "-docletpath", docletPath, "-doclet", "com.sebastian_daschner.jaxrs_analyzer.analysis.javadoc.JAXRSDoclet", "-encoding", encoding), packages.stream()).toArray(String[]::new);
        Class<?> javaDocMain = ContextClassReader.getClassLoader().loadClass("com.sun.tools.javadoc.Main");
        int result = (Integer)javaDocMain.getMethod("execute", String[].class).invoke(null, new Object[]{args});
        if (result != 0) {
            LogProvider.error("Error in javadoc analysis");
        }
    }

    private String joinPaths(Set<Path> projectSourcePaths) {
        return projectSourcePaths.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator));
    }

    private void combineResults(Set<ClassResult> classResults) {
        METHOD_DOCS.entrySet().forEach(e -> classResults.stream().map(c -> this.findMethodResult((MethodIdentifier)e.getKey(), (ClassResult)c)).filter(Objects::nonNull).forEach(m -> m.setMethodDoc((MethodDoc)e.getValue())));
    }

    private MethodResult findMethodResult(MethodIdentifier identifier, ClassResult classResult) {
        if (classResult.getOriginalClass().equals(identifier.getContainingClass())) {
            return classResult.getMethods().stream().filter(methodResult -> methodResult.getOriginalMethodSignature().equals(identifier)).findAny().orElse(null);
        }
        return classResult.getMethods().stream().map(MethodResult::getSubResource).filter(Objects::nonNull).map(c -> this.findMethodResult(identifier, (ClassResult)c)).filter(Objects::nonNull).findAny().orElse(null);
    }

    public static void put(MethodIdentifier identifier, MethodDoc methodDoc) {
        METHOD_DOCS.put(identifier, methodDoc);
    }

    public static void put(String className, ClassDoc classDoc) {
        CLASS_DOCS.put(className, classDoc);
    }

    public static MethodDoc get(MethodIdentifier identifier) {
        return METHOD_DOCS.get(identifier);
    }

    public static ClassDoc get(String className) {
        return CLASS_DOCS.get(className);
    }
}

