/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.javadoc;

import com.sebastian_daschner.jaxrs_analyzer.analysis.javadoc.JavaDocAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.model.JavaUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.MethodIdentifier;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.RootDoc;
import java.util.stream.Stream;

public class JAXRSDoclet {
    public static boolean start(RootDoc rootDoc) {
        Stream.of(rootDoc.classes()).forEach(JAXRSDoclet::handleClassDoc);
        return true;
    }

    private static void handleClassDoc(ClassDoc classDoc) {
        String className = JAXRSDoclet.toClassName(classDoc.qualifiedName());
        JavaDocAnalyzer.put(className, classDoc);
        Stream.of(classDoc.methods()).forEach(m -> JAXRSDoclet.handleMethodDoc(m, className));
    }

    private static void handleMethodDoc(MethodDoc methodDoc, String className) {
        String[] parameterTypes = (String[])Stream.of(methodDoc.parameters()).map(p -> p.type().qualifiedTypeName()).map(JAXRSDoclet::toType).toArray(String[]::new);
        String returnType = JAXRSDoclet.toType(methodDoc.returnType().qualifiedTypeName());
        String signature = JavaUtils.getMethodSignature(returnType, parameterTypes);
        MethodIdentifier identifier = MethodIdentifier.of(className, methodDoc.name(), signature, methodDoc.isStatic());
        JavaDocAnalyzer.put(identifier, methodDoc);
    }

    private static String toClassName(String qualifiedName) {
        return qualifiedName.replace('.', '/');
    }

    private static String toType(String qualifiedName) {
        switch (qualifiedName) {
            case "void": {
                return "V";
            }
            case "boolean": {
                return "Z";
            }
            case "char": {
                return "C";
            }
            case "int": {
                return "I";
            }
            case "byte": {
                return "B";
            }
            case "short": {
                return "S";
            }
            case "double": {
                return "D";
            }
            case "float": {
                return "F";
            }
            case "long": {
                return "J";
            }
        }
        return JavaUtils.toType(JAXRSDoclet.toClassName(qualifiedName));
    }
}

