/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.reduction;

import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.reduction.InstructionFinder;
import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.reduction.StackSizeSimulator;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.Instruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.LoadInstruction;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RelevantInstructionReducer {
    private static final String[] VARIABLE_NAMES_TO_IGNORE = new String[]{"this"};
    private final Lock lock = new ReentrantLock();
    private final StackSizeSimulator stackSizeSimulator = new StackSizeSimulator();
    private List<Instruction> instructions;

    public List<Instruction> reduceInstructions(List<Instruction> instructions) {
        this.lock.lock();
        try {
            this.instructions = instructions;
            this.stackSizeSimulator.buildStackSizes(instructions);
            List<Instruction> list = this.reduceInstructionsInternal(instructions);
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    private List<Instruction> reduceInstructionsInternal(List<Instruction> instructions) {
        LinkedList<Instruction> visitedInstructions = new LinkedList<Instruction>();
        HashSet<Integer> visitedInstructionPositions = new HashSet<Integer>();
        HashSet<Integer> handledLoadIndexes = new HashSet<Integer>();
        LinkedHashSet<Integer> backtrackPositions = new LinkedHashSet<Integer>(this.findSortedBacktrackPositions());
        while (!visitedInstructionPositions.containsAll(backtrackPositions)) {
            int backtrackPosition = backtrackPositions.stream().filter(pos -> !visitedInstructionPositions.contains(pos)).findFirst().orElseThrow(IllegalStateException::new);
            List<Integer> lastVisitedPositions = this.stackSizeSimulator.simulateStatementBackwards(backtrackPosition);
            List<Instruction> lastVisitedInstructions = lastVisitedPositions.stream().map(instructions::get).collect(Collectors.toList());
            visitedInstructionPositions.addAll(lastVisitedPositions);
            visitedInstructions.addAll(lastVisitedInstructions);
            Set<Integer> unhandledLoadIndexes = this.findUnhandledLoadIndexes(handledLoadIndexes, lastVisitedInstructions);
            SortedSet<Integer> loadStoreBacktrackPositions = this.findLoadStoreBacktrackPositions(unhandledLoadIndexes);
            handledLoadIndexes.addAll(unhandledLoadIndexes);
            loadStoreBacktrackPositions.stream().forEach(backtrackPositions::add);
        }
        Collections.reverse(visitedInstructions);
        return visitedInstructions;
    }

    private List<Integer> findSortedBacktrackPositions() {
        LinkedList<Integer> startPositions = new LinkedList<Integer>(InstructionFinder.findReturnsAndThrows(this.instructions));
        Collections.sort(startPositions, Comparator.reverseOrder());
        return startPositions;
    }

    private Set<Integer> findUnhandledLoadIndexes(Set<Integer> handledLoadIndexes, List<Instruction> lastVisitedInstructions) {
        Set<Integer> lastLoadIndexes = InstructionFinder.findLoadIndexes(lastVisitedInstructions, RelevantInstructionReducer::isLoadIgnored);
        return lastLoadIndexes.stream().filter(k -> !handledLoadIndexes.contains(k)).collect(Collectors.toSet());
    }

    private static boolean isLoadIgnored(LoadInstruction instruction) {
        return Stream.of(VARIABLE_NAMES_TO_IGNORE).anyMatch(instruction.getName()::equals);
    }

    private SortedSet<Integer> findLoadStoreBacktrackPositions(Set<Integer> unhandledLoadIndexes) {
        return unhandledLoadIndexes.stream().map(index -> this.stackSizeSimulator.findLoadStoreBacktrackPositions(InstructionFinder.findLoadStores(index, this.instructions))).collect(() -> new TreeSet(Comparator.reverseOrder()), Set::addAll, Set::addAll);
    }
}

