/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode;

import com.sebastian_daschner.jaxrs_analyzer.analysis.JobRegistry;
import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.MethodContentAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation.MethodPool;
import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation.MethodSimulator;
import com.sebastian_daschner.jaxrs_analyzer.model.JavaUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.Element;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.Instruction;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.ProjectMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.results.ClassResult;
import com.sebastian_daschner.jaxrs_analyzer.model.results.MethodResult;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class SubResourceLocatorMethodContentAnalyzer
extends MethodContentAnalyzer {
    private final Lock lock = new ReentrantLock();
    private final MethodSimulator simulator = new MethodSimulator();

    SubResourceLocatorMethodContentAnalyzer() {
    }

    void analyze(MethodResult methodResult) {
        this.lock.lock();
        try {
            this.buildPackagePrefix(methodResult.getParentResource().getOriginalClass());
            this.determineReturnTypes(methodResult).stream().reduce((l, r) -> JavaUtils.determineMostSpecificType(l, r)).ifPresent(t -> this.registerSubResourceJob((String)t, methodResult.getSubResource()));
        }
        finally {
            this.lock.unlock();
        }
    }

    private Set<String> determineReturnTypes(MethodResult result) {
        List<Instruction> visitedInstructions = this.interpretRelevantInstructions(result.getInstructions());
        Set<ProjectMethod> projectMethods = this.findProjectMethods(visitedInstructions);
        projectMethods.forEach(MethodPool.getInstance()::addProjectMethod);
        Element returnedElement = this.simulator.simulate(visitedInstructions);
        if (returnedElement == null) {
            return Collections.singleton(result.getOriginalMethodSignature().getReturnType());
        }
        return returnedElement.getTypes();
    }

    private void registerSubResourceJob(String type, ClassResult classResult) {
        String className = JavaUtils.toClassName(type);
        JobRegistry.getInstance().analyzeResourceClass(className, classResult);
    }
}

