/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.analysis.ProjectAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.backend.Backend;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Project;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Resources;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.StreamSupport;

public class JAXRSAnalyzer {
    private final Set<Path> projectClassPaths = new HashSet<Path>();
    private final Set<Path> projectSourcePaths = new HashSet<Path>();
    private final Set<Path> classPaths = new HashSet<Path>();
    private final String projectName;
    private final String projectVersion;
    private final Path outputLocation;
    private final Backend backend;

    public JAXRSAnalyzer(Set<Path> projectClassPaths, Set<Path> projectSourcePaths, Set<Path> classPaths, String projectName, String projectVersion, Backend backend, Path outputLocation) {
        Objects.requireNonNull(projectClassPaths);
        Objects.requireNonNull(projectSourcePaths);
        Objects.requireNonNull(classPaths);
        Objects.requireNonNull(projectName);
        Objects.requireNonNull(projectVersion);
        Objects.requireNonNull(backend);
        if (projectClassPaths.isEmpty()) {
            throw new IllegalArgumentException("At least one project path is mandatory");
        }
        this.projectClassPaths.addAll(projectClassPaths);
        this.projectSourcePaths.addAll(projectSourcePaths);
        this.classPaths.addAll(classPaths);
        this.projectName = projectName;
        this.projectVersion = projectVersion;
        this.outputLocation = outputLocation;
        this.backend = backend;
    }

    public void analyze() {
        Resources resources = new ProjectAnalyzer(this.classPaths).analyze(this.projectClassPaths, this.projectSourcePaths);
        if (resources.isEmpty()) {
            LogProvider.info("Empty JAX-RS analysis result, omitting output");
            return;
        }
        Project project = new Project(this.projectName, this.projectVersion, resources);
        byte[] output = this.backend.render(project);
        if (this.outputLocation != null) {
            JAXRSAnalyzer.outputToFile(output, this.outputLocation);
        } else {
            this.outputToConsole(output);
        }
    }

    private void outputToConsole(byte[] output) {
        try {
            System.out.write(output);
            System.out.flush();
        }
        catch (IOException e) {
            LogProvider.error("Could not write the output, reason: " + e.getMessage());
            LogProvider.debug(e);
        }
    }

    private static void outputToFile(byte[] output, Path outputLocation) {
        try (FileOutputStream stream = new FileOutputStream(outputLocation.toFile());){
            ((OutputStream)stream).write(output);
            stream.flush();
        }
        catch (IOException e) {
            LogProvider.error("Could not write to the specified output location, reason: " + e.getMessage());
            LogProvider.debug(e);
        }
    }

    public static Backend constructBackend(String backendType) {
        ServiceLoader<Backend> backends = ServiceLoader.load(Backend.class);
        return StreamSupport.stream(backends.spliterator(), false).filter(b -> backendType.equalsIgnoreCase(b.getName())).findAny().orElseThrow(() -> new IllegalArgumentException("Unknown backend type " + backendType));
    }
}

