/*
 * Copyright (C) 2015 Sebastian Daschner, sebastian-daschner.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sebastian_daschner.jaxrs_analyzer.model.methods;

import com.sebastian_daschner.jaxrs_analyzer.model.instructions.InvokeInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.Element;

import java.util.List;

/**
 * Represents a method which will be invoked via an {@link InvokeInstruction}.
 *
 * @author Sebastian Daschner
 */
public interface Method {

    /**
     * Invokes the method on the object with the given arguments.
     *
     * @param object    The object where the method is invoked ({@code null} for a static method)
     * @param arguments The arguments of the method
     * @return The method response or {@code null} for void
     */
    Element invoke(Element object, List<Element> arguments);

}
