/*
 * Decompiled with CFR 0.152.
 */
package com.sdsmdg.harjot.vectormaster.models;

import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.RectF;
import com.sdsmdg.harjot.vectormaster.DefaultValues;
import com.sdsmdg.harjot.vectormaster.utilities.Utils;
import com.sdsmdg.harjot.vectormaster.utilities.legacyparser.PathParser;

public class PathModel {
    private String name;
    private float fillAlpha = 1.0f;
    private int fillColor = 0;
    private Path.FillType fillType = DefaultValues.PATH_FILL_TYPE;
    private String pathData;
    private float trimPathStart = 0.0f;
    private float trimPathEnd = 1.0f;
    private float trimPathOffset = 0.0f;
    private float strokeAlpha = 1.0f;
    private int strokeColor = 0;
    private Paint.Cap strokeLineCap = DefaultValues.PATH_STROKE_LINE_CAP;
    private Paint.Join strokeLineJoin = DefaultValues.PATH_STROKE_LINE_JOIN;
    private float strokeMiterLimit = 4.0f;
    private float strokeWidth = 0.0f;
    private float strokeRatio = 1.0f;
    private boolean isFillAndStroke = false;
    private Path originalPath;
    private Path path;
    private Path trimmedPath;
    private Paint pathPaint = new Paint();
    private Matrix scaleMatrix;

    public PathModel() {
        this.pathPaint.setAntiAlias(true);
        this.updatePaint();
    }

    public void buildPath(boolean useLegacyParser) {
        this.originalPath = useLegacyParser ? PathParser.createPathFromPathData(this.pathData) : com.sdsmdg.harjot.vectormaster.utilities.parser.PathParser.doPath(this.pathData);
        if (this.originalPath != null) {
            this.originalPath.setFillType(this.fillType);
        }
        this.path = new Path(this.originalPath);
    }

    public void updatePaint() {
        this.pathPaint.setStrokeWidth(this.strokeWidth * this.strokeRatio);
        if (this.fillColor != 0 && this.strokeColor != 0) {
            this.isFillAndStroke = true;
        } else if (this.fillColor != 0) {
            this.pathPaint.setColor(this.fillColor);
            this.pathPaint.setAlpha(Utils.getAlphaFromFloat(this.fillAlpha));
            this.pathPaint.setStyle(Paint.Style.FILL);
            this.isFillAndStroke = false;
        } else if (this.strokeColor != 0) {
            this.pathPaint.setColor(this.strokeColor);
            this.pathPaint.setAlpha(Utils.getAlphaFromFloat(this.strokeAlpha));
            this.pathPaint.setStyle(Paint.Style.STROKE);
            this.isFillAndStroke = false;
        } else {
            this.pathPaint.setColor(0);
        }
        this.pathPaint.setStrokeCap(this.strokeLineCap);
        this.pathPaint.setStrokeJoin(this.strokeLineJoin);
        this.pathPaint.setStrokeMiter(this.strokeMiterLimit);
    }

    public void makeStrokePaint() {
        this.pathPaint.setColor(this.strokeColor);
        this.pathPaint.setAlpha(Utils.getAlphaFromFloat(this.strokeAlpha));
        this.pathPaint.setStyle(Paint.Style.STROKE);
    }

    public void makeFillPaint() {
        this.pathPaint.setColor(this.fillColor);
        this.pathPaint.setAlpha(Utils.getAlphaFromFloat(this.fillAlpha));
        this.pathPaint.setStyle(Paint.Style.FILL);
    }

    public void transform(Matrix matrix) {
        this.scaleMatrix = matrix;
        this.trimPath();
    }

    public void trimPath() {
        if (this.scaleMatrix != null) {
            if (this.trimPathStart == 0.0f && this.trimPathEnd == 1.0f && this.trimPathOffset == 0.0f) {
                this.path = new Path(this.originalPath);
                this.path.transform(this.scaleMatrix);
            } else {
                PathMeasure pathMeasure = new PathMeasure(this.originalPath, false);
                float length = pathMeasure.getLength();
                this.trimmedPath = new Path();
                pathMeasure.getSegment((this.trimPathStart + this.trimPathOffset) * length, (this.trimPathEnd + this.trimPathOffset) * length, this.trimmedPath, true);
                this.path = new Path(this.trimmedPath);
                this.path.transform(this.scaleMatrix);
            }
        }
    }

    public Path getTrimmedPath() {
        return this.trimmedPath;
    }

    public void setTrimmedPath(Path trimmedPath) {
        this.trimmedPath = trimmedPath;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public Path getScaledAndOffsetPath(float offsetX, float offsetY, float scaleX, float scaleY) {
        Path newPath = new Path(this.path);
        newPath.offset(offsetX, offsetY);
        newPath.transform(this.getScaleMatrix(newPath, scaleX, scaleY));
        return newPath;
    }

    public Matrix getScaleMatrix(Path srcPath, float scaleX, float scaleY) {
        Matrix scaleMatrix = new Matrix();
        RectF rectF = new RectF();
        srcPath.computeBounds(rectF, true);
        scaleMatrix.setScale(scaleX, scaleY, rectF.left, rectF.top);
        return scaleMatrix;
    }

    public Paint getPathPaint() {
        return this.pathPaint;
    }

    public void setPathPaint(Paint pathPaint) {
        this.pathPaint = pathPaint;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public float getFillAlpha() {
        return this.fillAlpha;
    }

    public void setFillAlpha(float fillAlpha) {
        this.fillAlpha = fillAlpha;
        this.updatePaint();
    }

    public int getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(int fillColor) {
        this.fillColor = fillColor;
        this.updatePaint();
    }

    public Path.FillType getFillType() {
        return this.fillType;
    }

    public void setFillType(Path.FillType fillType) {
        this.fillType = fillType;
        if (this.originalPath != null) {
            this.originalPath.setFillType(fillType);
        }
    }

    public String getPathData() {
        return this.pathData;
    }

    public void setPathData(String pathData) {
        this.pathData = pathData;
    }

    public float getTrimPathStart() {
        return this.trimPathStart;
    }

    public void setTrimPathStart(float trimPathStart) {
        this.trimPathStart = trimPathStart;
        this.trimPath();
    }

    public float getTrimPathEnd() {
        return this.trimPathEnd;
    }

    public void setTrimPathEnd(float trimPathEnd) {
        this.trimPathEnd = trimPathEnd;
        this.trimPath();
    }

    public float getTrimPathOffset() {
        return this.trimPathOffset;
    }

    public void setTrimPathOffset(float trimPathOffset) {
        this.trimPathOffset = trimPathOffset;
        this.trimPath();
    }

    public float getStrokeAlpha() {
        return this.strokeAlpha;
    }

    public void setStrokeAlpha(float strokeAlpha) {
        this.strokeAlpha = strokeAlpha;
        this.updatePaint();
    }

    public int getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(int strokeColor) {
        this.strokeColor = strokeColor;
        this.updatePaint();
    }

    public Paint.Cap getStrokeLineCap() {
        return this.strokeLineCap;
    }

    public void setStrokeLineCap(Paint.Cap strokeLineCap) {
        this.strokeLineCap = strokeLineCap;
        this.updatePaint();
    }

    public Paint.Join getStrokeLineJoin() {
        return this.strokeLineJoin;
    }

    public void setStrokeLineJoin(Paint.Join strokeLineJoin) {
        this.strokeLineJoin = strokeLineJoin;
        this.updatePaint();
    }

    public float getStrokeMiterLimit() {
        return this.strokeMiterLimit;
    }

    public void setStrokeMiterLimit(float strokeMiterLimit) {
        this.strokeMiterLimit = strokeMiterLimit;
        this.updatePaint();
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(float strokeWidth) {
        this.strokeWidth = strokeWidth;
        this.updatePaint();
    }

    public float getStrokeRatio() {
        return this.strokeRatio;
    }

    public void setStrokeRatio(float strokeRatio) {
        this.strokeRatio = strokeRatio;
        this.updatePaint();
    }

    public boolean isFillAndStroke() {
        return this.isFillAndStroke;
    }
}

