/*
 * Decompiled with CFR 0.152.
 */
package com.sdsmdg.harjot.vectormaster.models;

import android.graphics.Canvas;
import android.graphics.Matrix;
import com.sdsmdg.harjot.vectormaster.models.ClipPathModel;
import com.sdsmdg.harjot.vectormaster.models.PathModel;
import com.sdsmdg.harjot.vectormaster.utilities.Utils;
import java.util.ArrayList;

public class GroupModel {
    private String name;
    private float rotation = 0.0f;
    private float pivotX = 0.0f;
    private float pivotY = 0.0f;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float translateX = 0.0f;
    private float translateY = 0.0f;
    private Matrix scaleMatrix;
    private Matrix originalTransformMatrix;
    private Matrix finalTransformMatrix;
    private GroupModel parent;
    private ArrayList<GroupModel> groupModels = new ArrayList();
    private ArrayList<PathModel> pathModels = new ArrayList();
    private ArrayList<ClipPathModel> clipPathModels = new ArrayList();

    public void drawPaths(Canvas canvas, float offsetX, float offsetY, float scaleX, float scaleY) {
        for (ClipPathModel clipPathModel : this.clipPathModels) {
            canvas.clipPath(clipPathModel.getScaledAndOffsetPath(offsetX, offsetY, scaleX, scaleY));
        }
        for (GroupModel groupModel : this.groupModels) {
            groupModel.drawPaths(canvas, offsetX, offsetY, scaleX, scaleY);
        }
        for (PathModel pathModel : this.pathModels) {
            if (pathModel.isFillAndStroke()) {
                pathModel.makeFillPaint();
                canvas.drawPath(pathModel.getScaledAndOffsetPath(offsetX, offsetY, scaleX, scaleY), pathModel.getPathPaint());
                pathModel.makeStrokePaint();
                canvas.drawPath(pathModel.getScaledAndOffsetPath(offsetX, offsetY, scaleX, scaleY), pathModel.getPathPaint());
                continue;
            }
            canvas.drawPath(pathModel.getScaledAndOffsetPath(offsetX, offsetY, scaleX, scaleY), pathModel.getPathPaint());
        }
    }

    public void drawPaths(Canvas canvas) {
        for (ClipPathModel clipPathModel : this.clipPathModels) {
            canvas.clipPath(clipPathModel.getPath());
        }
        for (GroupModel groupModel : this.groupModels) {
            groupModel.drawPaths(canvas);
        }
        for (PathModel pathModel : this.pathModels) {
            if (pathModel.isFillAndStroke()) {
                pathModel.makeFillPaint();
                canvas.drawPath(pathModel.getPath(), pathModel.getPathPaint());
                pathModel.makeStrokePaint();
                canvas.drawPath(pathModel.getPath(), pathModel.getPathPaint());
                continue;
            }
            canvas.drawPath(pathModel.getPath(), pathModel.getPathPaint());
        }
    }

    public void scaleAllPaths(Matrix scaleMatrix) {
        this.scaleMatrix = scaleMatrix;
        this.finalTransformMatrix = new Matrix(this.originalTransformMatrix);
        this.finalTransformMatrix.postConcat(scaleMatrix);
        for (GroupModel groupModel : this.groupModels) {
            groupModel.scaleAllPaths(scaleMatrix);
        }
        for (PathModel pathModel : this.pathModels) {
            pathModel.transform(this.finalTransformMatrix);
        }
        for (ClipPathModel clipPathModel : this.clipPathModels) {
            clipPathModel.transform(this.finalTransformMatrix);
        }
    }

    public void scaleAllStrokeWidth(float ratio) {
        for (GroupModel groupModel : this.groupModels) {
            groupModel.scaleAllStrokeWidth(ratio);
        }
        for (PathModel pathModel : this.pathModels) {
            pathModel.setStrokeRatio(ratio);
        }
    }

    public void buildTransformMatrix() {
        this.originalTransformMatrix = new Matrix();
        this.originalTransformMatrix.postScale(this.scaleX, this.scaleY, this.pivotX, this.pivotY);
        this.originalTransformMatrix.postRotate(this.rotation, this.pivotX, this.pivotY);
        this.originalTransformMatrix.postTranslate(this.translateX, this.translateY);
        if (this.parent != null) {
            this.originalTransformMatrix.postConcat(this.parent.getOriginalTransformMatrix());
        }
        for (GroupModel groupModel : this.groupModels) {
            groupModel.buildTransformMatrix();
        }
    }

    public void updateAndScalePaths() {
        if (this.scaleMatrix != null) {
            this.buildTransformMatrix();
            this.scaleAllPaths(this.scaleMatrix);
        }
    }

    public GroupModel getGroupModelByName(String name) {
        GroupModel grpModel = null;
        for (GroupModel groupModel : this.groupModels) {
            if (Utils.isEqual(groupModel.getName(), name)) {
                grpModel = groupModel;
                return grpModel;
            }
            grpModel = groupModel.getGroupModelByName(name);
            if (grpModel == null) continue;
            return grpModel;
        }
        return grpModel;
    }

    public PathModel getPathModelByName(String name) {
        PathModel pModel = null;
        for (PathModel pathModel : this.pathModels) {
            if (!Utils.isEqual(pathModel.getName(), name)) continue;
            return pathModel;
        }
        for (GroupModel groupModel : this.groupModels) {
            pModel = groupModel.getPathModelByName(name);
            if (pModel == null || !Utils.isEqual(pModel.getName(), name)) continue;
            return pModel;
        }
        return pModel;
    }

    public ClipPathModel getClipPathModelByName(String name) {
        ClipPathModel cModel = null;
        for (ClipPathModel clipPathModel : this.getClipPathModels()) {
            if (!Utils.isEqual(clipPathModel.getName(), name)) continue;
            return clipPathModel;
        }
        for (GroupModel groupModel : this.getGroupModels()) {
            cModel = groupModel.getClipPathModelByName(name);
            if (cModel == null || !Utils.isEqual(cModel.getName(), name)) continue;
            return cModel;
        }
        return cModel;
    }

    public Matrix getOriginalTransformMatrix() {
        return this.originalTransformMatrix;
    }

    public GroupModel getParent() {
        return this.parent;
    }

    public void setParent(GroupModel parent) {
        this.parent = parent;
    }

    public void addGroupModel(GroupModel groupModel) {
        this.groupModels.add(groupModel);
    }

    public ArrayList<GroupModel> getGroupModels() {
        return this.groupModels;
    }

    public void addPathModel(PathModel pathModel) {
        this.pathModels.add(pathModel);
    }

    public ArrayList<PathModel> getPathModels() {
        return this.pathModels;
    }

    public void addClipPathModel(ClipPathModel clipPathModel) {
        this.clipPathModels.add(clipPathModel);
    }

    public ArrayList<ClipPathModel> getClipPathModels() {
        return this.clipPathModels;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float rotation) {
        this.rotation = rotation;
        this.updateAndScalePaths();
    }

    public float getPivotX() {
        return this.pivotX;
    }

    public void setPivotX(float pivotX) {
        this.pivotX = pivotX;
    }

    public float getPivotY() {
        return this.pivotY;
    }

    public void setPivotY(float pivotY) {
        this.pivotY = pivotY;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(float scaleX) {
        this.scaleX = scaleX;
        this.updateAndScalePaths();
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(float scaleY) {
        this.scaleY = scaleY;
        this.updateAndScalePaths();
    }

    public float getTranslateX() {
        return this.translateX;
    }

    public void setTranslateX(float translateX) {
        this.translateX = translateX;
        this.updateAndScalePaths();
    }

    public float getTranslateY() {
        return this.translateY;
    }

    public void setTranslateY(float translateY) {
        this.translateY = translateY;
        this.updateAndScalePaths();
    }
}

