/*
 * Decompiled with CFR 0.152.
 */
package com.sdsmdg.harjot.vectormaster.models;

import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import com.sdsmdg.harjot.vectormaster.utilities.legacyparser.PathParser;

public class ClipPathModel {
    private String name;
    private String pathData;
    private Path originalPath;
    private Path path = new Path();
    private Paint clipPaint = new Paint();

    public ClipPathModel() {
        this.clipPaint.setAntiAlias(true);
        this.clipPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
    }

    public void buildPath(boolean useLegacyParser) {
        this.originalPath = useLegacyParser ? PathParser.createPathFromPathData(this.pathData) : com.sdsmdg.harjot.vectormaster.utilities.parser.PathParser.doPath(this.pathData);
        this.path = new Path(this.originalPath);
    }

    public void transform(Matrix matrix) {
        this.path = new Path(this.originalPath);
        this.path.transform(matrix);
    }

    public Paint getClipPaint() {
        return this.clipPaint;
    }

    public void setClipPaint(Paint clipPaint) {
        this.clipPaint = clipPaint;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPathData() {
        return this.pathData;
    }

    public void setPathData(String pathData) {
        this.pathData = pathData;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public Path getScaledAndOffsetPath(float offsetX, float offsetY, float scaleX, float scaleY) {
        Path newPath = new Path(this.path);
        newPath.offset(offsetX, offsetY);
        newPath.transform(this.getScaleMatrix(newPath, scaleX, scaleY));
        return newPath;
    }

    public Matrix getScaleMatrix(Path srcPath, float scaleX, float scaleY) {
        Matrix scaleMatrix = new Matrix();
        RectF rectF = new RectF();
        srcPath.computeBounds(rectF, true);
        scaleMatrix.setScale(scaleX, scaleY, rectF.left, rectF.top);
        return scaleMatrix;
    }
}

