/*
 * Decompiled with CFR 0.152.
 */
package com.sdsmdg.harjot.vectormaster;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import com.sdsmdg.harjot.vectormaster.DefaultValues;
import com.sdsmdg.harjot.vectormaster.models.ClipPathModel;
import com.sdsmdg.harjot.vectormaster.models.GroupModel;
import com.sdsmdg.harjot.vectormaster.models.PathModel;
import com.sdsmdg.harjot.vectormaster.models.VectorModel;
import com.sdsmdg.harjot.vectormaster.utilities.Utils;
import java.io.IOException;
import java.util.Stack;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class VectorMasterDrawable
extends Drawable {
    private VectorModel vectorModel;
    private Context context;
    private Resources resources;
    private int resID = -1;
    private boolean useLegacyParser = true;
    private float offsetX = 0.0f;
    private float offsetY = 0.0f;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private XmlPullParser xpp;
    String TAG = "VECTOR_MASTER";
    private Matrix scaleMatrix;
    private int width = -1;
    private int height = -1;
    private float scaleRatio;
    private float strokeRatio;
    private int left = 0;
    private int top = 0;
    private int tempSaveCount;

    public VectorMasterDrawable(Context context, int resID) {
        this.context = context;
        this.resID = resID;
        this.init();
    }

    public VectorMasterDrawable(Context context, int resID, float offsetX, float offsetY) {
        this.context = context;
        this.resID = resID;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.init();
    }

    public VectorMasterDrawable(Context context, int resID, float offsetX, float offsetY, float scaleX, float scaleY) {
        this.context = context;
        this.resID = resID;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.init();
    }

    private void init() {
        this.resources = this.context.getResources();
        this.buildVectorModel();
    }

    private void buildVectorModel() {
        if (this.resID == -1) {
            this.vectorModel = null;
            return;
        }
        this.xpp = this.resources.getXml(this.resID);
        PathModel pathModel = new PathModel();
        this.vectorModel = new VectorModel();
        GroupModel groupModel = new GroupModel();
        ClipPathModel clipPathModel = new ClipPathModel();
        Stack<GroupModel> groupModelStack = new Stack<GroupModel>();
        try {
            int event = this.xpp.getEventType();
            while (event != 1) {
                String name = this.xpp.getName();
                switch (event) {
                    case 2: {
                        int tempPosition;
                        if (name.equals("vector")) {
                            tempPosition = this.getAttrPosition(this.xpp, "viewportWidth");
                            this.vectorModel.setViewportWidth(tempPosition != -1 ? Float.parseFloat(this.xpp.getAttributeValue(tempPosition)) : 0.0f);
                            tempPosition = this.getAttrPosition(this.xpp, "viewportHeight");
                            this.vectorModel.setViewportHeight(tempPosition != -1 ? Float.parseFloat(this.xpp.getAttributeValue(tempPosition)) : 0.0f);
                            tempPosition = this.getAttrPosition(this.xpp, "alpha");
                            this.vectorModel.setAlpha(tempPosition != -1 ? Float.parseFloat(this.xpp.getAttributeValue(tempPosition)) : 1.0f);
                            tempPosition = this.getAttrPosition(this.xpp, "name");
                            this.vectorModel.setName(tempPosition != -1 ? this.xpp.getAttributeValue(tempPosition) : null);
                            tempPosition = this.getAttrPosition(this.xpp, "width");
                            this.vectorModel.setWidth(tempPosition != -1 ? Utils.getFloatFromDimensionString(this.xpp.getAttributeValue(tempPosition)) : 0.0f);
                            tempPosition = this.getAttrPosition(this.xpp, "height");
                            this.vectorModel.setHeight(tempPosition != -1 ? Utils.getFloatFromDimensionString(this.xpp.getAttributeValue(tempPosition)) : 0.0f);
                            break;
                        }
                        if (name.equals("path")) {
                            pathModel = new PathModel();
                            tempPosition = this.getAttrPosition(this.xpp, "name");
                            pathModel.setName(tempPosition != -1 ? this.xpp.getAttributeValue(tempPosition) : null);
                            tempPosition = this.getAttrPosition(this.xpp, "fillAlpha");
                            pathModel.setFillAlpha(tempPosition != -1 ? Float.parseFloat(this.xpp.getAttributeValue(tempPosition)) : 1.0f);
                            tempPosition = this.getAttrPosition(this.xpp, "fillColor");
                            pathModel.setFillColor(tempPosition != -1 ? Utils.getColorFromString(this.xpp.getAttributeValue(tempPosition)) : 0);
                            tempPosition = this.getAttrPosition(this.xpp, "fillType");
                            pathModel.setFillType(tempPosition != -1 ? Utils.getFillTypeFromString(this.xpp.getAttributeValue(tempPosition)) : DefaultValues.PATH_FILL_TYPE);
                            tempPosition = this.getAttrPosition(this.xpp, "pathData");
                            pathModel.setPathData(tempPosition != -1 ? this.xpp.getAttributeValue(tempPosition) : null);
                            tempPosition = this.getAttrPosition(this.xpp, "strokeAlpha");
                            pathModel.setStrokeAlpha(tempPosition != -1 ? Float.parseFloat(this.xpp.getAttributeValue(tempPosition)) : 1.0f);
                            tempPosition = this.getAttrPosition(this.xpp, "strokeColor");
                            pathModel.setStrokeColor(tempPosition != -1 ? Utils.getColorFromString(this.xpp.getAttributeValue(tempPosition)) : 0);
                            tempPosition = this.getAttrPosition(this.xpp, "strokeLineCap");
                            pathModel.setStrokeLineCap(tempPosition != -1 ? Utils.getLineCapFromString(this.xpp.getAttributeValue(tempPosition)) : DefaultValues.PATH_STROKE_LINE_CAP);
                            tempPosition = this.getAttrPosition(this.xpp, "strokeLineJoin");
                            pathModel.setStrokeLineJoin(tempPosition != -1 ? Utils.getLineJoinFromString(this.xpp.getAttributeValue(tempPosition)) : DefaultValues.PATH_STROKE_LINE_JOIN);
                            tempPosition = this.getAttrPosition(this.xpp, "strokeMiterLimit");
                            pathModel.setStrokeMiterLimit(tempPosition != -1 ? Float.parseFloat(this.xpp.getAttributeValue(tempPosition)) : 4.0f);
                            tempPosition = this.getAttrPosition(this.xpp, "strokeWidth");
                            pathModel.setStrokeWidth(tempPosition != -1 ? Float.parseFloat(this.xpp.getAttributeValue(tempPosition)) : 0.0f);
                            tempPosition = this.getAttrPosition(this.xpp, "trimPathEnd");
                            pathModel.setTrimPathEnd(tempPosition != -1 ? Float.parseFloat(this.xpp.getAttributeValue(tempPosition)) : 1.0f);
                            tempPosition = this.getAttrPosition(this.xpp, "trimPathOffset");
                            pathModel.setTrimPathOffset(tempPosition != -1 ? Float.parseFloat(this.xpp.getAttributeValue(tempPosition)) : 0.0f);
                            tempPosition = this.getAttrPosition(this.xpp, "trimPathStart");
                            pathModel.setTrimPathStart(tempPosition != -1 ? Float.parseFloat(this.xpp.getAttributeValue(tempPosition)) : 0.0f);
                            pathModel.buildPath(this.useLegacyParser);
                            break;
                        }
                        if (name.equals("group")) {
                            groupModel = new GroupModel();
                            tempPosition = this.getAttrPosition(this.xpp, "name");
                            groupModel.setName(tempPosition != -1 ? this.xpp.getAttributeValue(tempPosition) : null);
                            tempPosition = this.getAttrPosition(this.xpp, "pivotX");
                            groupModel.setPivotX(tempPosition != -1 ? Float.parseFloat(this.xpp.getAttributeValue(tempPosition)) : 0.0f);
                            tempPosition = this.getAttrPosition(this.xpp, "pivotY");
                            groupModel.setPivotY(tempPosition != -1 ? Float.parseFloat(this.xpp.getAttributeValue(tempPosition)) : 0.0f);
                            tempPosition = this.getAttrPosition(this.xpp, "rotation");
                            groupModel.setRotation(tempPosition != -1 ? Float.parseFloat(this.xpp.getAttributeValue(tempPosition)) : 0.0f);
                            tempPosition = this.getAttrPosition(this.xpp, "scaleX");
                            groupModel.setScaleX(tempPosition != -1 ? Float.parseFloat(this.xpp.getAttributeValue(tempPosition)) : 1.0f);
                            tempPosition = this.getAttrPosition(this.xpp, "scaleY");
                            groupModel.setScaleY(tempPosition != -1 ? Float.parseFloat(this.xpp.getAttributeValue(tempPosition)) : 1.0f);
                            tempPosition = this.getAttrPosition(this.xpp, "translateX");
                            groupModel.setTranslateX(tempPosition != -1 ? Float.parseFloat(this.xpp.getAttributeValue(tempPosition)) : 0.0f);
                            tempPosition = this.getAttrPosition(this.xpp, "translateY");
                            groupModel.setTranslateY(tempPosition != -1 ? Float.parseFloat(this.xpp.getAttributeValue(tempPosition)) : 0.0f);
                            groupModelStack.push(groupModel);
                            break;
                        }
                        if (!name.equals("clip-path")) break;
                        clipPathModel = new ClipPathModel();
                        tempPosition = this.getAttrPosition(this.xpp, "name");
                        clipPathModel.setName(tempPosition != -1 ? this.xpp.getAttributeValue(tempPosition) : null);
                        tempPosition = this.getAttrPosition(this.xpp, "pathData");
                        clipPathModel.setPathData(tempPosition != -1 ? this.xpp.getAttributeValue(tempPosition) : null);
                        clipPathModel.buildPath(this.useLegacyParser);
                        break;
                    }
                    case 3: {
                        if (name.equals("path")) {
                            if (groupModelStack.size() == 0) {
                                this.vectorModel.addPathModel(pathModel);
                            } else {
                                ((GroupModel)groupModelStack.peek()).addPathModel(pathModel);
                            }
                            this.vectorModel.getFullpath().addPath(pathModel.getPath());
                            break;
                        }
                        if (name.equals("clip-path")) {
                            if (groupModelStack.size() == 0) {
                                this.vectorModel.addClipPathModel(clipPathModel);
                                break;
                            }
                            ((GroupModel)groupModelStack.peek()).addClipPathModel(clipPathModel);
                            break;
                        }
                        if (name.equals("group")) {
                            GroupModel topGroupModel = (GroupModel)groupModelStack.pop();
                            if (groupModelStack.size() == 0) {
                                topGroupModel.setParent(null);
                                this.vectorModel.addGroupModel(topGroupModel);
                                break;
                            }
                            topGroupModel.setParent((GroupModel)groupModelStack.peek());
                            ((GroupModel)groupModelStack.peek()).addGroupModel(topGroupModel);
                            break;
                        }
                        if (!name.equals("vector")) break;
                        this.vectorModel.buildTransformMatrices();
                    }
                }
                event = this.xpp.next();
            }
        }
        catch (IOException | XmlPullParserException e) {
            e.printStackTrace();
        }
    }

    private int getAttrPosition(XmlPullParser xpp, String attrName) {
        for (int i = 0; i < xpp.getAttributeCount(); ++i) {
            if (!xpp.getAttributeName(i).equals(attrName)) continue;
            return i;
        }
        return -1;
    }

    public int getResID() {
        return this.resID;
    }

    public void setResID(int resID) {
        this.resID = resID;
        this.buildVectorModel();
        this.scaleMatrix = null;
    }

    public boolean isUseLegacyParser() {
        return this.useLegacyParser;
    }

    public void setUseLegacyParser(boolean useLegacyParser) {
        this.useLegacyParser = useLegacyParser;
        this.buildVectorModel();
        this.scaleMatrix = null;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        if (bounds.width() != 0 && bounds.height() != 0) {
            this.left = bounds.left;
            this.top = bounds.top;
            this.width = bounds.width();
            this.height = bounds.height();
            this.buildScaleMatrix();
            this.scaleAllPaths();
            this.scaleAllStrokes();
        }
    }

    public void draw(Canvas canvas) {
        if (this.vectorModel == null) {
            return;
        }
        if (this.scaleMatrix == null) {
            int temp1 = Utils.dpToPx((int)this.vectorModel.getWidth());
            int temp2 = Utils.dpToPx((int)this.vectorModel.getHeight());
            this.setBounds(0, 0, temp1, temp2);
        }
        this.setAlpha(Utils.getAlphaFromFloat(this.vectorModel.getAlpha()));
        if (this.left != 0 || this.top != 0) {
            this.tempSaveCount = canvas.save();
            canvas.translate((float)this.left, (float)this.top);
            this.vectorModel.drawPaths(canvas, this.offsetX, this.offsetY, this.scaleX, this.scaleY);
            canvas.restoreToCount(this.tempSaveCount);
        } else {
            this.vectorModel.drawPaths(canvas, this.offsetX, this.offsetY, this.scaleX, this.scaleY);
        }
    }

    public void setAlpha(int i) {
        this.vectorModel.setAlpha(Utils.getAlphaFromInt(i));
    }

    public void setColorFilter(ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return -3;
    }

    public int getIntrinsicWidth() {
        return Utils.dpToPx((int)this.vectorModel.getWidth());
    }

    public int getIntrinsicHeight() {
        return Utils.dpToPx((int)this.vectorModel.getHeight());
    }

    private void buildScaleMatrix() {
        float ratio;
        this.scaleMatrix = new Matrix();
        this.scaleMatrix.postTranslate((float)(this.width / 2) - this.vectorModel.getViewportWidth() / 2.0f, (float)(this.height / 2) - this.vectorModel.getViewportHeight() / 2.0f);
        float widthRatio = (float)this.width / this.vectorModel.getViewportWidth();
        float heightRatio = (float)this.height / this.vectorModel.getViewportHeight();
        this.scaleRatio = ratio = Math.min(widthRatio, heightRatio);
        this.scaleMatrix.postScale(ratio, ratio, (float)(this.width / 2), (float)(this.height / 2));
    }

    private void scaleAllPaths() {
        this.vectorModel.scaleAllPaths(this.scaleMatrix);
    }

    private void scaleAllStrokes() {
        this.strokeRatio = Math.min((float)this.width / this.vectorModel.getWidth(), (float)this.height / this.vectorModel.getHeight());
        this.vectorModel.scaleAllStrokeWidth(this.strokeRatio);
    }

    public Path getFullPath() {
        if (this.vectorModel != null) {
            return this.vectorModel.getFullpath();
        }
        return null;
    }

    public GroupModel getGroupModelByName(String name) {
        for (GroupModel groupModel : this.vectorModel.getGroupModels()) {
            if (Utils.isEqual(groupModel.getName(), name)) {
                return groupModel;
            }
            GroupModel gModel = groupModel.getGroupModelByName(name);
            if (gModel == null) continue;
            return gModel;
        }
        return null;
    }

    public PathModel getPathModelByName(String name) {
        PathModel pModel = null;
        for (PathModel pathModel : this.vectorModel.getPathModels()) {
            if (!Utils.isEqual(pathModel.getName(), name)) continue;
            return pathModel;
        }
        for (GroupModel groupModel : this.vectorModel.getGroupModels()) {
            pModel = groupModel.getPathModelByName(name);
            if (pModel == null || !Utils.isEqual(pModel.getName(), name)) continue;
            return pModel;
        }
        return pModel;
    }

    public ClipPathModel getClipPathModelByName(String name) {
        ClipPathModel cModel = null;
        for (ClipPathModel clipPathModel : this.vectorModel.getClipPathModels()) {
            if (!Utils.isEqual(clipPathModel.getName(), name)) continue;
            return clipPathModel;
        }
        for (GroupModel groupModel : this.vectorModel.getGroupModels()) {
            cModel = groupModel.getClipPathModelByName(name);
            if (cModel == null || !Utils.isEqual(cModel.getName(), name)) continue;
            return cModel;
        }
        return cModel;
    }

    public void update() {
        this.invalidateSelf();
    }

    public float getScaleRatio() {
        return this.scaleRatio;
    }

    public float getStrokeRatio() {
        return this.strokeRatio;
    }

    public Matrix getScaleMatrix() {
        return this.scaleMatrix;
    }

    public float getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(float offsetX) {
        this.offsetX = offsetX;
        this.invalidateSelf();
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(float offsetY) {
        this.offsetY = offsetY;
        this.invalidateSelf();
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(float scaleX) {
        this.scaleX = scaleX;
        this.invalidateSelf();
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(float scaleY) {
        this.scaleY = scaleY;
        this.invalidateSelf();
    }
}

